/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.experiment;

import org.apache.submarine.commons.utils.AbstractUniqueIdGenerator;

public class ExperimentId
extends AbstractUniqueIdGenerator<ExperimentId> {
    private static final String EXPERIMENT_ID_PREFIX = "experiment-";

    public static ExperimentId fromString(String jobId) {
        if (jobId == null) {
            return null;
        }
        String[] components = jobId.split("\\-");
        if (components.length != 3) {
            return null;
        }
        return ExperimentId.newInstance(Long.parseLong(components[1]), Integer.parseInt(components[2]));
    }

    public static ExperimentId newInstance(long serverTimestamp, int id) {
        ExperimentId experimentId = new ExperimentId();
        experimentId.setServerTimestamp(serverTimestamp);
        experimentId.setId(id);
        return experimentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(EXPERIMENT_ID_PREFIX).append(this.getServerTimestamp()).append("-");
        this.format(sb, this.getId());
        return sb.toString();
    }
}

