/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.experimenttemplate;

import org.apache.submarine.commons.utils.AbstractUniqueIdGenerator;

public class ExperimentTemplateId
extends AbstractUniqueIdGenerator<ExperimentTemplateId> {
    private static final String EXPERIMENT_ID_PREFIX = "experimentTemplate_";

    public static ExperimentTemplateId fromString(String experimentTemplateId) {
        if (experimentTemplateId == null) {
            return null;
        }
        String[] components = experimentTemplateId.split("\\_");
        if (components.length != 3) {
            return null;
        }
        return ExperimentTemplateId.newInstance(Long.parseLong(components[1]), Integer.parseInt(components[2]));
    }

    public static ExperimentTemplateId newInstance(long serverTimestamp, int id) {
        ExperimentTemplateId experimentId = new ExperimentTemplateId();
        experimentId.setServerTimestamp(serverTimestamp);
        experimentId.setId(id);
        return experimentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(EXPERIMENT_ID_PREFIX).append(this.getServerTimestamp()).append("_");
        this.format(sb, this.getId());
        return sb.toString();
    }
}

