/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.notebook;

import org.apache.submarine.commons.utils.AbstractUniqueIdGenerator;

public class NotebookId
extends AbstractUniqueIdGenerator<NotebookId> {
    private static final String NOTEBOOK_ID_PREFIX = "notebook_";

    public static NotebookId fromString(String notebookId) {
        if (notebookId == null) {
            return null;
        }
        String[] components = notebookId.split("\\_");
        if (components.length != 3) {
            return null;
        }
        return NotebookId.newInstance(Long.parseLong(components[1]), Integer.parseInt(components[2]));
    }

    public static NotebookId newInstance(long serverTimestamp, int id) {
        NotebookId notebookId = new NotebookId();
        notebookId.setServerTimestamp(serverTimestamp);
        notebookId.setId(id);
        return notebookId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(NOTEBOOK_ID_PREFIX).append(this.getServerTimestamp()).append("_");
        this.format(sb, this.getId());
        return sb.toString();
    }
}

