/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.spec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentMeta {
    public static final String SUBMARINE_EXPERIMENT_NAME = "submarine-experiment-name";
    private String experimentId;
    private String name;
    private String namespace = "default";
    private String framework;
    private String cmd;
    private Map<String, String> envVars = new HashMap<String, String>();
    private List<String> tags = new ArrayList<String>();

    public ExperimentMeta() {
        if (System.getenv("ENV_NAMESPACE") != null) {
            this.namespace = System.getenv("ENV_NAMESPACE");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
    }

    public String getFramework() {
        return this.framework;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String toString() {
        return "ExperimentMeta{name='" + this.name + '\'' + ", experimentId='" + this.experimentId + '\'' + ", namespace='" + this.namespace + '\'' + ", framework='" + this.framework + '\'' + ", cmd='" + this.cmd + '\'' + ", envVars=" + this.envVars + ", tags=" + this.tags + '}';
    }

    public static enum SupportedMLFramework {
        TENSORFLOW("tensorflow"),
        PYTORCH("pytorch");

        private final String name;

        private SupportedMLFramework(String frName) {
            this.name = frName;
        }

        public String getName() {
            return this.name;
        }

        public static String[] names() {
            SupportedMLFramework[] frameworks = SupportedMLFramework.values();
            String[] names = new String[frameworks.length];
            for (int i = 0; i < frameworks.length; ++i) {
                names[i] = frameworks[i].name();
            }
            return names;
        }
    }
}

