/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.spec;

import java.util.HashMap;
import java.util.Map;

public class ExperimentTaskSpec {
    private Integer replicas = 1;
    private String resources;
    private String name;
    private String image;
    private String cmd;
    private Map<String, String> envVars;
    private Map<String, String> resourceMap;

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public String getResources() {
        return this.resources;
    }

    public void setResources(String resources) {
        this.resources = resources;
        this.parseResources();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    private void parseResources() {
        if (this.resources != null) {
            this.resourceMap = new HashMap<String, String>();
            for (String item : this.resources.split(",")) {
                String[] r = item.split("=");
                if (r.length != 2) continue;
                this.resourceMap.put(r[0], r[1]);
            }
        }
    }

    public String getCpu() {
        return this.resourceMap.get("cpu");
    }

    public String getMemory() {
        return this.resourceMap.get("memory");
    }

    public String getGpu() {
        return this.resourceMap.get("nvidia.com/gpu");
    }
}

