/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.spec;

import java.util.HashMap;
import java.util.Map;

public class NotebookPodSpec {
    private Map<String, String> envVars;
    private String resources;
    private transient Map<String, String> resourceMap;

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public String getResources() {
        return this.resources;
    }

    public void setResources(String resources) {
        this.resources = resources;
        this.parseResources();
    }

    public void parseResources() {
        if (this.resources != null) {
            this.resourceMap = new HashMap<String, String>();
            for (String item : this.resources.split(",")) {
                String[] r = item.split("=");
                if (r.length != 2) continue;
                this.resourceMap.put(r[0], r[1]);
            }
        }
    }

    public String getCpu() {
        return this.resourceMap.get("cpu");
    }

    public String getMemory() {
        return this.resourceMap.get("memory");
    }

    public String getGpu() {
        return this.resourceMap.get("nvidia.com/gpu");
    }
}

