/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.submitter.yarn;

import com.linkedin.tony.TonyConfigurationKeys;
import com.linkedin.tony.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.submarine.client.cli.param.Localization;
import org.apache.submarine.client.cli.param.ParametersHolder;
import org.apache.submarine.commons.runtime.Framework;
import org.apache.submarine.commons.runtime.param.Parameter;
import org.apache.submarine.commons.runtime.resource.ResourceUtils;

public final class YarnUtils {
    private static final Log LOG = LogFactory.getLog(YarnUtils.class);

    public static Configuration tonyConfFromClientContext(ParametersHolder parameters) throws YarnException, ParseException {
        Configuration tonyConf = new Configuration();
        tonyConf.addResource("tony.xml");
        tonyConf.setStrings("tony.application.framework", new String[]{parameters.getFramework().getValue()});
        tonyConf.setStrings("tony.application.name", new String[]{parameters.getParameters().getName()});
        YarnUtils.setParametersForWorker(tonyConf, parameters);
        YarnUtils.setParametersForPS(tonyConf, parameters);
        if (parameters.getFramework() == Framework.MXNET) {
            YarnUtils.setParametersForScheduler(tonyConf, parameters);
        }
        if (parameters.getOptionValue("queue") != null) {
            tonyConf.set("tony.yarn.queue", parameters.getOptionValue("queue"));
        }
        if (parameters.getOptionValue("docker_image") != null) {
            tonyConf.set(TonyConfigurationKeys.getContainerDockerKey(), parameters.getOptionValue("docker_image"));
            tonyConf.setBoolean("tony.docker.enabled", true);
        }
        if (parameters.getOptionValues("env") != null) {
            List envs = parameters.getOptionValues("env");
            tonyConf.setStrings("tony.containers.envs", envs.toArray(new String[0]));
            tonyConf.setStrings("tony.execution.envs", (String[])envs.stream().map(env -> env.replaceAll("DOCKER_", "")).toArray(String[]::new));
            tonyConf.setStrings("tony.containers.envs", (String[])envs.stream().map(env -> env.replaceAll("DOCKER_", "")).toArray(String[]::new));
        }
        tonyConf.setBoolean("tony.application.security.enabled", !parameters.hasOption("insecure"));
        if (parameters.getOptionValues("localization") != null) {
            List localizationsStr = parameters.getOptionValues("localization");
            ArrayList<Localization> localizations = new ArrayList<Localization>();
            for (String loc : localizationsStr) {
                Localization localization = new Localization();
                localization.parse(loc);
                localizations.add(localization);
            }
            tonyConf.setStrings(TonyConfigurationKeys.getContainerResourcesKey(), (String[])localizations.stream().map(lo -> lo.getRemoteUri() + "::" + lo.getLocalPath()).toArray(String[]::new));
        }
        if (parameters.getOptionValues("conf") != null) {
            String[] confArray = parameters.getOptionValues("conf").toArray(new String[0]);
            for (Map.Entry cliConf : Utils.parseKeyValue((String[])confArray).entrySet()) {
                String[] existingValue = tonyConf.getStrings((String)cliConf.getKey());
                if (existingValue != null && TonyConfigurationKeys.MULTI_VALUE_CONF.contains(cliConf.getKey())) {
                    ArrayList<String> newValues = new ArrayList<String>(Arrays.asList(existingValue));
                    newValues.add((String)cliConf.getValue());
                    tonyConf.setStrings((String)cliConf.getKey(), newValues.toArray(new String[0]));
                    continue;
                }
                tonyConf.set((String)cliConf.getKey(), (String)cliConf.getValue());
            }
        }
        LOG.info((Object)("Resources: " + tonyConf.get(TonyConfigurationKeys.getContainerResourcesKey())));
        return tonyConf;
    }

    private YarnUtils() {
    }

    private static Resource getResource(Parameter parametersHolder, String option) throws ParseException, YarnException {
        String resourceStr = parametersHolder.getOptionValue(option);
        if (resourceStr == null) {
            throw new ParseException("--" + option + " is absent.");
        }
        return ResourceUtils.createResourceFromString((String)resourceStr);
    }

    private static void setParametersForWorker(Configuration tonyConf, ParametersHolder parameters) throws YarnException, ParseException {
        tonyConf.setStrings(TonyConfigurationKeys.getInstancesKey((String)"worker"), new String[]{parameters.getOptionValue("num_workers")});
        if (parameters.getOptionValue("worker_resources") != null) {
            Resource workerResource = YarnUtils.getResource((Parameter)parameters, "worker_resources");
            tonyConf.setInt(TonyConfigurationKeys.getResourceKey((String)"worker", (String)"vcores"), workerResource.getVirtualCores());
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)"worker", (String)"memory"), ResourceUtils.getMemorySize((Resource)workerResource));
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)"worker", (String)"gpus"), ResourceUtils.getResourceValue((Resource)workerResource, (String)"yarn.io/gpu"));
        }
        if (parameters.getOptionValue("worker_docker_image") != null) {
            tonyConf.set(TonyConfigurationKeys.getDockerImageKey((String)"worker"), parameters.getOptionValue("worker_docker_image"));
            tonyConf.setBoolean("tony.docker.enabled", true);
        }
        if (parameters.getOptionValue("worker_launch_cmd") != null) {
            tonyConf.set(TonyConfigurationKeys.getExecuteCommandKey((String)"worker"), parameters.getOptionValue("worker_launch_cmd"));
        }
    }

    private static void setParametersForPS(Configuration tonyConf, ParametersHolder parameters) throws YarnException, ParseException {
        String jobName = "ps";
        if (parameters.getFramework() == Framework.MXNET) {
            jobName = "server";
        }
        if (parameters.getOptionValue("num_ps") != null) {
            tonyConf.setStrings(TonyConfigurationKeys.getInstancesKey((String)jobName), new String[]{parameters.getOptionValue("num_ps")});
        }
        if (parameters.getOptionValue("ps_resources") != null) {
            Resource psResource = YarnUtils.getResource((Parameter)parameters, "ps_resources");
            tonyConf.setInt(TonyConfigurationKeys.getResourceKey((String)jobName, (String)"vcores"), psResource.getVirtualCores());
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)jobName, (String)"memory"), ResourceUtils.getMemorySize((Resource)psResource));
        }
        if (parameters.getOptionValue("ps_launch_cmd") != null) {
            tonyConf.set(TonyConfigurationKeys.getExecuteCommandKey((String)jobName), parameters.getOptionValue("ps_launch_cmd"));
        }
        if (parameters.getOptionValue("ps_docker_image") != null) {
            tonyConf.set(TonyConfigurationKeys.getDockerImageKey((String)jobName), parameters.getOptionValue("ps_docker_image"));
            tonyConf.setBoolean("tony.docker.enabled", true);
        }
    }

    private static void setParametersForScheduler(Configuration tonyConf, ParametersHolder parameters) throws YarnException, ParseException {
        if (parameters.getOptionValue("num_schedulers") != null) {
            tonyConf.setStrings(TonyConfigurationKeys.getInstancesKey((String)"scheduler"), new String[]{parameters.getOptionValue("num_schedulers")});
        }
        if (parameters.getOptionValue("scheduler_resources") != null) {
            Resource schedulerResource = YarnUtils.getResource((Parameter)parameters, "scheduler_resources");
            tonyConf.setInt(TonyConfigurationKeys.getResourceKey((String)"scheduler", (String)"vcores"), schedulerResource.getVirtualCores());
            tonyConf.setLong(TonyConfigurationKeys.getResourceKey((String)"scheduler", (String)"memory"), ResourceUtils.getMemorySize((Resource)schedulerResource));
        }
        if (parameters.getOptionValue("scheduler_launch_cmd") != null) {
            tonyConf.set(TonyConfigurationKeys.getExecuteCommandKey((String)"scheduler"), parameters.getOptionValue("scheduler_launch_cmd"));
        }
        if (parameters.getOptionValue("scheduler_docker_image") != null) {
            tonyConf.set(TonyConfigurationKeys.getDockerImageKey((String)"scheduler"), parameters.getOptionValue("scheduler_docker_image"));
        }
    }
}

