/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.Condition;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializer;
import org.apache.synapse.commons.evaluators.config.EvaluatorSerializerFinder;

public class ConditionSerializer {
    private static Log log = LogFactory.getLog(ConditionSerializer.class);
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();
    private static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public OMElement serializer(OMElement parent, Condition condition) throws EvaluatorException {
        OMElement conditionElement = fac.createOMElement(new QName("condition"));
        conditionElement.addAttribute(fac.createOMAttribute("priority", nullNS, condition.getPriority() + ""));
        EvaluatorSerializer serializer = EvaluatorSerializerFinder.getInstance().getSerializer(condition.getEvaluator().getName());
        if (serializer == null) {
            String msg = "Couldn't find the serializer for evaliator: " + condition.getEvaluator().getName();
            log.error((Object)msg);
            throw new EvaluatorException(msg);
        }
        serializer.serialize(conditionElement, condition.getEvaluator());
        if (parent != null) {
            parent.addChild((OMNode)conditionElement);
        }
        return conditionElement;
    }
}

