/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.ocsp;

import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.cache.CacheController;
import org.apache.synapse.transport.utils.sslcert.cache.CacheManager;
import org.apache.synapse.transport.utils.sslcert.cache.ManageableCache;
import org.apache.synapse.transport.utils.sslcert.cache.ManageableCacheValue;
import org.apache.synapse.transport.utils.sslcert.ocsp.OCSPVerifier;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class OCSPCache
implements ManageableCache {
    private static final Log log = LogFactory.getLog(OCSPCache.class);
    private static final OCSPCache cache = new OCSPCache();
    private final Map<BigInteger, OCSPCacheValue> hashMap = new ConcurrentHashMap<BigInteger, OCSPCacheValue>();
    private Iterator<Map.Entry<BigInteger, OCSPCacheValue>> iterator = this.hashMap.entrySet().iterator();
    private volatile CacheManager cacheManager;
    private final OCSPVerifier ocspVerifier = new OCSPVerifier(null);

    private OCSPCache() {
    }

    public static OCSPCache getCache() {
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int size, int delay) {
        if (this.cacheManager != null) return;
        Class<OCSPCache> clazz = OCSPCache.class;
        synchronized (OCSPCache.class) {
            if (this.cacheManager != null) return;
            this.cacheManager = new CacheManager(cache, size, delay);
            CacheController mbean = new CacheController(cache, this.cacheManager);
            MBeanRegistrar.getInstance().registerMBean((Object)mbean, "CacheController", "OCSPCacheController");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ManageableCacheValue getNextCacheValue() {
        if (this.iterator.hasNext()) {
            return this.hashMap.get(this.iterator.next().getKey());
        }
        this.resetIterator();
        return null;
    }

    @Override
    public int getCacheSize() {
        return this.hashMap.size();
    }

    @Override
    public synchronized void resetIterator() {
        this.iterator = this.hashMap.entrySet().iterator();
    }

    private synchronized void replaceNewCacheValue(OCSPCacheValue cacheValue) {
        if (cacheValue.isValid()) {
            return;
        }
        try {
            SingleResp[] responses;
            String serviceUrl = cacheValue.serviceUrl;
            OCSPReq request = cacheValue.request;
            OCSPResp response = this.ocspVerifier.getOCSPResponse(serviceUrl, request);
            if (0 != response.getStatus()) {
                throw new CertificateVerificationException("OCSP response status not SUCCESSFUL");
            }
            BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
            SingleResp[] singleRespArray = responses = basicResponse == null ? null : basicResponse.getResponses();
            if (responses == null) {
                throw new CertificateVerificationException("Cant get OCSP response");
            }
            SingleResp resp = responses[0];
            this.setCacheValue(cacheValue.serialNumber, resp, request, serviceUrl);
        }
        catch (Exception e) {
            log.debug((Object)"Cant replace old CacheValue with new CacheValue. So remove", (Throwable)e);
            cacheValue.removeThisCacheValue();
        }
    }

    public synchronized SingleResp getCacheValue(BigInteger serialNumber) {
        OCSPCacheValue cacheValue = this.hashMap.get(serialNumber);
        if (cacheValue != null) {
            if (!cacheValue.isValid()) {
                cacheValue.updateCacheWithNewValue();
                OCSPCacheValue ocspCacheValue = this.hashMap.get(serialNumber);
                return ocspCacheValue != null ? ocspCacheValue.getValue() : null;
            }
            return cacheValue.getValue();
        }
        return null;
    }

    public synchronized void setCacheValue(BigInteger serialNumber, SingleResp singleResp, OCSPReq request, String serviceUrl) {
        OCSPCacheValue cacheValue = new OCSPCacheValue(serialNumber, singleResp, request, serviceUrl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Before set - HashMap size " + this.hashMap.size()));
        }
        this.hashMap.put(serialNumber, cacheValue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After set - HashMap size " + this.hashMap.size()));
        }
    }

    public synchronized void removeCacheValue(BigInteger serialNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Before remove - HashMap size " + this.hashMap.size()));
        }
        this.hashMap.remove(serialNumber);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After remove - HashMap size " + this.hashMap.size()));
        }
    }

    private class OCSPCacheValue
    implements ManageableCacheValue {
        private BigInteger serialNumber;
        private SingleResp singleResp;
        private OCSPReq request;
        private String serviceUrl;
        private long timeStamp = System.currentTimeMillis();

        public OCSPCacheValue(BigInteger serialNumber, SingleResp singleResp, OCSPReq request, String serviceUrl) {
            this.serialNumber = serialNumber;
            this.singleResp = singleResp;
            this.request = request;
            this.serviceUrl = serviceUrl;
        }

        public BigInteger getKey() {
            return this.serialNumber;
        }

        public SingleResp getValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.singleResp;
        }

        @Override
        public boolean isValid() {
            Date now = new Date();
            Date nextUpdate = this.singleResp.getNextUpdate();
            return nextUpdate != null && nextUpdate.after(now);
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void removeThisCacheValue() {
            OCSPCache.this.removeCacheValue(this.serialNumber);
        }

        @Override
        public void updateCacheWithNewValue() {
            OCSPCache.this.replaceNewCacheValue(this);
        }
    }
}

