/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya;

import java.util.logging.Logger;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.ConfigurationProviderSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(ConfigurationProvider.class.getName());

    private static ConfigurationProviderSpi spi() {
        ConfigurationProviderSpi spi = ServiceContextManager.getServiceContext().getService(ConfigurationProviderSpi.class);
        if (spi == null) {
            throw new IllegalStateException("ConfigurationProviderSpi not available.");
        }
        LOG.info("TAMAYA Loaded ConfigurationProviderSpi: " + spi.getClass().getName());
        return spi;
    }

    private ConfigurationProvider() {
    }

    public static Configuration getConfiguration() {
        return ConfigurationProvider.spi().getConfiguration();
    }

    public static Configuration createConfiguration(ConfigurationContext context) {
        return ConfigurationProvider.spi().createConfiguration(context);
    }

    @Deprecated
    public static ConfigurationContext getConfigurationContext() {
        return ConfigurationProvider.spi().getConfigurationContext();
    }

    @Deprecated
    public static void setConfigurationContext(ConfigurationContext context) {
        ConfigurationProvider.spi().setConfigurationContext(context);
    }

    public static void setConfiguration(Configuration config) {
        LOG.info("TAMAYA Applying new Configuration: " + config);
        ConfigurationProvider.spi().setConfiguration(config);
    }

    public static ConfigurationContextBuilder getConfigurationContextBuilder() {
        return ConfigurationProvider.spi().getConfigurationContextBuilder();
    }
}

