/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertyConverter;

public class ConversionContext {
    private final Configuration configuration;
    private final String key;
    private final TypeLiteral<?> targetType;
    private final AnnotatedElement annotatedElement;
    private final List<String> supportedFormats = new ArrayList<String>();
    private final ConfigurationContext configurationContext;

    protected ConversionContext(Builder builder) {
        this.key = builder.key;
        this.annotatedElement = builder.annotatedElement;
        this.targetType = builder.targetType;
        this.supportedFormats.addAll(builder.supportedFormats);
        this.configuration = builder.configuration;
        this.configurationContext = builder.configurationContext;
    }

    public String getKey() {
        return this.key;
    }

    public TypeLiteral<?> getTargetType() {
        return this.targetType;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSupportedFormats(Class<? extends PropertyConverter> converterType, String ... formatDescriptors) {
        List<String> list = this.supportedFormats;
        synchronized (list) {
            for (String format : formatDescriptors) {
                this.supportedFormats.add(format + " (" + converterType.getSimpleName() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSupportedFormats() {
        List<String> list = this.supportedFormats;
        synchronized (list) {
            return new ArrayList<String>(this.supportedFormats);
        }
    }

    public String toString() {
        return "ConversionContext{configuration=" + this.configuration + ", key='" + this.key + '\'' + ", targetType=" + this.targetType + ", annotatedElement=" + this.annotatedElement + ", supportedFormats=" + this.supportedFormats + '}';
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public static final class Builder {
        private Configuration configuration;
        private ConfigurationContext configurationContext;
        private String key;
        private final TypeLiteral<?> targetType;
        private AnnotatedElement annotatedElement;
        private final Set<String> supportedFormats = new HashSet<String>();

        public Builder(TypeLiteral<?> targetType) {
            this(null, null, null, targetType);
        }

        public Builder(String key, TypeLiteral<?> targetType) {
            this(null, null, key, targetType);
        }

        public Builder(Configuration configuration, ConfigurationContext configurationContext, String key, TypeLiteral<?> targetType) {
            this.key = key;
            this.configuration = configuration;
            this.configurationContext = configurationContext;
            this.targetType = Objects.requireNonNull(targetType);
        }

        public Builder setKey(String key) {
            this.key = Objects.requireNonNull(key);
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = Objects.requireNonNull(configuration);
            return this;
        }

        public Builder setConfigurationContext(ConfigurationContext configurationContext) {
            this.configurationContext = Objects.requireNonNull(configurationContext);
            return this;
        }

        public Builder setAnnotatedElement(AnnotatedElement annotatedElement) {
            this.annotatedElement = Objects.requireNonNull(annotatedElement);
            return this;
        }

        public Builder addSupportedFormats(Class<? extends PropertyConverter> converterType, String ... formatDescriptors) {
            for (String format : formatDescriptors) {
                this.supportedFormats.add(format + " (" + converterType.getSimpleName() + ")");
            }
            return this;
        }

        public ConversionContext build() {
            return new ConversionContext(this);
        }

        public String toString() {
            return "Builder{configuration=" + this.configuration + "context=" + this.configurationContext + ", key='" + this.key + '\'' + ", targetType=" + this.targetType + ", annotatedElement=" + this.annotatedElement + ", supportedFormats=" + this.supportedFormats + '}';
        }
    }
}

