/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.PropertyValueBuilder;

public final class PropertyValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String key;
    private String value;
    private String source;
    private Map<String, String> metaEntries = new HashMap<String, String>();

    PropertyValue(PropertyValueBuilder builder) {
        this.key = Objects.requireNonNull(builder.key);
        this.value = builder.value;
        this.source = Objects.requireNonNull(builder.source);
        if (builder.metaEntries != null) {
            this.metaEntries.putAll(builder.metaEntries);
        }
    }

    private PropertyValue(String key, String value, String source) {
        this.key = Objects.requireNonNull(key, "Key is required.");
        this.value = Objects.requireNonNull(value, "Value is required.");
        this.source = Objects.requireNonNull(source, "Source is required.");
    }

    public String getKey() {
        return this.key;
    }

    public String getSource() {
        return this.source;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getMetaEntries() {
        return Collections.unmodifiableMap(this.metaEntries);
    }

    public static PropertyValueBuilder builder(String key, String source) {
        Objects.requireNonNull(key, "Key must be given.");
        Objects.requireNonNull(source, "Source must be given");
        return new PropertyValueBuilder(key, source);
    }

    public static PropertyValueBuilder builder(String key, String value, String source) {
        Objects.requireNonNull(key, "Key must be given.");
        Objects.requireNonNull(value, "Value must be given");
        Objects.requireNonNull(source, "Source must be given.");
        return new PropertyValueBuilder(key, value, source);
    }

    public static PropertyValue of(String key, String value, String source) {
        if (value == null) {
            return null;
        }
        return new PropertyValue(key, value, source);
    }

    public String getMetaEntry(String key) {
        return this.metaEntries.get(Objects.requireNonNull(key));
    }

    public PropertyValueBuilder toBuilder() {
        return new PropertyValueBuilder(this.getKey(), this.getSource()).setValue(this.getValue()).setMetaEntries(this.metaEntries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyValue)) {
            return false;
        }
        PropertyValue that = (PropertyValue)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getMetaEntries(), that.getMetaEntries());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getValue(), this.getSource(), this.getMetaEntries());
    }

    public String toString() {
        return "PropertyValue{key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", source='" + this.source + '\'' + (this.metaEntries.isEmpty() ? "" : ", metaEntries=" + this.metaEntries) + '}';
    }

    public static Map<String, PropertyValue> map(Map<String, String> config, String source) {
        HashMap<String, PropertyValue> result = new HashMap<String, PropertyValue>(config.size());
        for (Map.Entry<String, String> en : config.entrySet()) {
            result.put(en.getKey(), PropertyValue.of(en.getKey(), en.getValue(), source));
        }
        return result;
    }

    public static Map<String, PropertyValue> map(Map<String, String> config, String source, Map<String, String> metaData) {
        Objects.requireNonNull(config, "Config must be given.");
        Objects.requireNonNull(source, "Source must be given.");
        Objects.requireNonNull(metaData, "Meta data must be given.");
        HashMap<String, PropertyValue> result = new HashMap<String, PropertyValue>(config.size());
        for (Map.Entry<String, String> en : config.entrySet()) {
            PropertyValue value = new PropertyValueBuilder(en.getKey(), source).setValue(en.getValue()).addMetaEntries(metaData).build();
            result.put(en.getKey(), value);
        }
        return result;
    }
}

