/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.PropertyValue;

public class PropertyValueBuilder {
    String key;
    String value;
    String source;
    Map<String, String> metaEntries = new HashMap<String, String>();

    PropertyValueBuilder(String key) {
        this.key = Objects.requireNonNull(key);
    }

    PropertyValueBuilder(String key, String source) {
        this.key = Objects.requireNonNull(key);
        this.source = Objects.requireNonNull(source);
    }

    PropertyValueBuilder(String key, String value, String source) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
        this.source = Objects.requireNonNull(source);
    }

    public PropertyValueBuilder setMetaEntries(Map<String, String> metaEntries) {
        this.metaEntries.clear();
        this.metaEntries.putAll(metaEntries);
        return this;
    }

    public PropertyValueBuilder addMetaEntry(String key, Object value) {
        Objects.requireNonNull(key, "Meta key must be given.");
        Objects.requireNonNull(value, "Meta value must be given.");
        this.metaEntries.put(key, String.valueOf(value));
        return this;
    }

    public PropertyValueBuilder addMetaEntries(Map<String, String> metaEntries) {
        this.metaEntries.putAll(metaEntries);
        return this;
    }

    public PropertyValueBuilder removeMetaEntry(String key) {
        Objects.requireNonNull(key, "Key must be given.");
        this.metaEntries.remove(key);
        return this;
    }

    public Map<String, String> getMetaEntries() {
        return Collections.unmodifiableMap(this.metaEntries);
    }

    public PropertyValueBuilder mapKey(String key) {
        HashMap<String, String> newContext = new HashMap<String, String>();
        for (Map.Entry<String, String> en : this.metaEntries.entrySet()) {
            if (en.getKey().startsWith("_" + this.key)) {
                newContext.put("_" + key + '.' + en.getKey().substring(this.key.length() + 1), en.getValue());
                continue;
            }
            newContext.put(en.getKey(), en.getValue());
        }
        this.metaEntries = newContext;
        this.key = key;
        return this;
    }

    public PropertyValueBuilder setKey(String key) {
        this.key = Objects.requireNonNull(key);
        return this;
    }

    public PropertyValueBuilder setValue(String value) {
        this.value = Objects.requireNonNull(value, "Value must be given.");
        return this;
    }

    public PropertyValueBuilder setSource(String source) {
        this.source = Objects.requireNonNull(source);
        return this;
    }

    public PropertyValue build() {
        return new PropertyValue(this);
    }

    public String toString() {
        return "PropertyValueBuilder{key='" + this.key + '\'' + "value='" + this.value + '\'' + ", metaEntries=" + this.metaEntries + '}';
    }
}

