/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.internal.services.AccessableObjectAnnotationProvider;
import org.apache.tapestry5.ioc.internal.services.AnnotationProviderChain;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.util.ExceptionUtils;

public class PropertyAdapterImpl
implements PropertyAdapter {
    private final ClassPropertyAdapter classAdapter;
    private final String name;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class type;
    private final boolean castRequired;
    private AnnotationProvider annotationProvider;
    private final Field field;
    private final Class declaringClass;

    PropertyAdapterImpl(ClassPropertyAdapter classAdapter, String name, Class type, Method readMethod, Method writeMethod) {
        this.classAdapter = classAdapter;
        this.name = name;
        this.type = type;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.declaringClass = readMethod != null ? readMethod.getDeclaringClass() : writeMethod.getDeclaringClass();
        this.castRequired = readMethod != null && readMethod.getReturnType() != type;
        this.field = null;
    }

    PropertyAdapterImpl(ClassPropertyAdapter classAdapter, String name, Class type, Field field) {
        this.classAdapter = classAdapter;
        this.name = name;
        this.type = type;
        this.field = field;
        this.declaringClass = field.getDeclaringClass();
        this.castRequired = field.getType() != type;
        this.readMethod = null;
        this.writeMethod = null;
    }

    public String getName() {
        return this.name;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Class getType() {
        return this.type;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isRead() {
        return this.field != null || this.readMethod != null;
    }

    public boolean isUpdate() {
        return this.writeMethod != null || this.field != null && !this.isFinal(this.field);
    }

    private boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public Object get(Object instance) {
        Throwable fail;
        if (this.field == null && this.readMethod == null) {
            throw new UnsupportedOperationException(String.format("Class %s does not provide an accessor ('getter') method for property '%s'.", this.toClassName(instance), this.name));
        }
        try {
            if (this.field == null) {
                return this.readMethod.invoke(instance, new Object[0]);
            }
            return this.field.get(instance);
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        throw new RuntimeException(ServiceMessages.readFailure((String)this.name, (Object)instance, (Throwable)fail), fail);
    }

    public void set(Object instance, Object value) {
        Throwable fail;
        if (this.field == null && this.writeMethod == null) {
            throw new UnsupportedOperationException(String.format("Class %s does not provide a mutator ('setter') method for property '%s'.", this.toClassName(instance), this.name));
        }
        try {
            if (this.field == null) {
                this.writeMethod.invoke(instance, value);
            } else {
                this.field.set(instance, value);
            }
            return;
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        throw new RuntimeException(String.format("Error updating property '%s' of %s: %s", this.name, this.toClassName(instance), ExceptionUtils.toMessage((Throwable)fail)), fail);
    }

    private String toClassName(Object instance) {
        return instance == null ? "<null>" : instance.getClass().getName();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getAnnnotationProvider().getAnnotation(annotationClass);
    }

    private synchronized AnnotationProvider getAnnnotationProvider() {
        if (this.annotationProvider == null) {
            List providers = CollectionFactory.newList();
            if (this.readMethod != null) {
                providers.add(new AccessableObjectAnnotationProvider((AccessibleObject)this.readMethod));
            }
            if (this.writeMethod != null) {
                providers.add(new AccessableObjectAnnotationProvider((AccessibleObject)this.writeMethod));
            }
            block0: for (Class cursor = this.getBeanType(); cursor != null; cursor = cursor.getSuperclass()) {
                for (Field f : cursor.getDeclaredFields()) {
                    if (!f.getName().equalsIgnoreCase(this.name)) continue;
                    providers.add(new AccessableObjectAnnotationProvider((AccessibleObject)f));
                    break block0;
                }
            }
            this.annotationProvider = AnnotationProviderChain.create((List)providers);
        }
        return this.annotationProvider;
    }

    public boolean isCastRequired() {
        return this.castRequired;
    }

    public ClassPropertyAdapter getClassAdapter() {
        return this.classAdapter;
    }

    public Class getBeanType() {
        return this.classAdapter.getBeanType();
    }

    public boolean isField() {
        return this.field != null;
    }

    public Field getField() {
        return this.field;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }
}

