/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.tapestry5.internal.plastic.FailureMethodInvocationResult;
import org.apache.tapestry5.internal.plastic.InstructionBuilderImpl;
import org.apache.tapestry5.internal.plastic.MethodAdviceManager;
import org.apache.tapestry5.internal.plastic.MethodHandleImpl;
import org.apache.tapestry5.internal.plastic.MethodParameterImpl;
import org.apache.tapestry5.internal.plastic.PlasticClassHandleShim;
import org.apache.tapestry5.internal.plastic.PlasticClassImpl;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.PlasticMember;
import org.apache.tapestry5.internal.plastic.SuccessMethodInvocationResult;
import org.apache.tapestry5.internal.plastic.TypeCategory;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodHandle;
import org.apache.tapestry5.plastic.MethodParameter;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.SwitchBlock;
import org.apache.tapestry5.plastic.TryCatchBlock;
import org.apache.tapestry5.plastic.TryCatchCallback;

class PlasticMethodImpl
extends PlasticMember
implements PlasticMethod,
Comparable<PlasticMethodImpl> {
    private final MethodNode node;
    private MethodDescription description;
    private MethodHandleImpl handle;
    private MethodAdviceManager adviceManager;
    private List<MethodParameter> parameters;
    private int methodIndex = -1;
    private String methodIdentifier;

    public PlasticMethodImpl(PlasticClassImpl plasticClass, MethodNode node) {
        super(plasticClass, node.visibleAnnotations);
        this.node = node;
        this.description = PlasticInternalUtils.toMethodDescription(node);
    }

    public String toString() {
        return String.format("PlasticMethod[%s in class %s]", this.description, this.plasticClass.className);
    }

    @Override
    public PlasticClass getPlasticClass() {
        this.plasticClass.check();
        return this.plasticClass;
    }

    @Override
    public MethodDescription getDescription() {
        this.plasticClass.check();
        return this.description;
    }

    @Override
    public int compareTo(PlasticMethodImpl o) {
        this.plasticClass.check();
        return this.description.compareTo(o.description);
    }

    @Override
    public boolean isOverride() {
        this.plasticClass.check();
        return this.plasticClass.parentInheritanceData.isImplemented(this.node.name, this.node.desc);
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.node.access);
    }

    @Override
    public String getMethodIdentifier() {
        this.plasticClass.check();
        if (this.methodIdentifier == null) {
            this.methodIdentifier = String.format("%s.%s", this.plasticClass.className, this.description.toShortString());
        }
        return this.methodIdentifier;
    }

    @Override
    public boolean isVoid() {
        this.plasticClass.check();
        return this.description.returnType.equals("void");
    }

    @Override
    public MethodHandle getHandle() {
        this.plasticClass.check();
        if (this.handle == null) {
            this.methodIndex = this.plasticClass.nextMethodIndex++;
            this.handle = new MethodHandleImpl(this.plasticClass.className, this.description.toString(), this.methodIndex);
            this.plasticClass.shimMethods.add(this);
        }
        return this.handle;
    }

    @Override
    public PlasticMethod changeImplementation(InstructionBuilderCallback callback) {
        this.plasticClass.check();
        if (Modifier.isAbstract(this.node.access)) {
            this.node.access &= 0xFFFFFBFF;
            this.description = this.description.withModifiers(this.node.access);
        }
        this.node.instructions.clear();
        this.plasticClass.newBuilder(this.description, this.node).doCallback(callback);
        this.plasticClass.fieldTransformMethods.add(this.node);
        return this;
    }

    @Override
    public PlasticMethod addAdvice(MethodAdvice advice) {
        this.plasticClass.check();
        assert (advice != null);
        if (this.adviceManager == null) {
            this.adviceManager = new MethodAdviceManager(this.plasticClass, this.description, this.node);
            this.plasticClass.advisedMethods.add(this);
        }
        this.adviceManager.add(advice);
        return this;
    }

    @Override
    public PlasticMethod delegateTo(final PlasticField field) {
        this.plasticClass.check();
        assert (field != null);
        assert (field.getPlasticClass() == this.plasticClass);
        this.changeImplementation(new InstructionBuilderCallback(){

            @Override
            public void doBuild(InstructionBuilder builder) {
                builder.loadThis().getField(field);
                builder.loadArguments();
                PlasticMethodImpl.this.invokeDelegateAndReturnResult(builder, field.getTypeName());
            }
        });
        return this;
    }

    @Override
    public PlasticMethod delegateTo(PlasticMethod delegateProvidingMethod) {
        this.plasticClass.check();
        assert (delegateProvidingMethod != null);
        assert (delegateProvidingMethod.getPlasticClass() == this.plasticClass);
        final MethodDescription providerDescriptor = delegateProvidingMethod.getDescription();
        final String delegateType = providerDescriptor.returnType;
        if (delegateType.equals("void") || providerDescriptor.argumentTypes.length > 0) {
            throw new IllegalArgumentException(String.format("Method %s is not usable as a delegate provider; it must be a void method that takes no arguments.", delegateProvidingMethod));
        }
        this.changeImplementation(new InstructionBuilderCallback(){

            @Override
            public void doBuild(InstructionBuilder builder) {
                builder.loadThis();
                if (Modifier.isPrivate(providerDescriptor.modifiers)) {
                    builder.invokeSpecial(PlasticMethodImpl.this.plasticClass.className, providerDescriptor);
                } else {
                    builder.invokeVirtual(PlasticMethodImpl.this.plasticClass.className, delegateType, providerDescriptor.methodName, new String[0]);
                }
                builder.loadArguments();
                PlasticMethodImpl.this.invokeDelegateAndReturnResult(builder, delegateType);
            }
        });
        return this;
    }

    @Override
    public List<MethodParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = PlasticInternalUtils.newList();
            for (int i = 0; i < this.description.argumentTypes.length; ++i) {
                this.parameters.add(new MethodParameterImpl(this.plasticClass, PlasticClassImpl.safeArrayDeref(this.node.visibleParameterAnnotations, i), PlasticClassImpl.safeArrayDeref(this.description.argumentTypes, i), i));
            }
        }
        return this.parameters;
    }

    void rewriteMethodForAdvice() {
        this.adviceManager.rewriteOriginalMethod();
    }

    private boolean isPrivate() {
        return Modifier.isPrivate(this.node.access);
    }

    private String setupMethodHandleAccess() {
        if (this.isPrivate()) {
            return this.createAccessMethod();
        }
        return this.node.name;
    }

    private String createAccessMethod() {
        String name = String.format("%s$access%s", this.node.name, PlasticUtils.nextUID());
        MethodNode mn = new MethodNode(4112, name, this.node.desc, this.node.signature, null);
        mn.exceptions = this.node.exceptions;
        InstructionBuilderImpl builder = this.plasticClass.newBuilder(mn);
        builder.loadThis();
        builder.loadArguments();
        builder.invokeSpecial(this.plasticClass.className, this.description);
        builder.returnResult();
        this.plasticClass.addMethod(mn);
        return name;
    }

    void installShim(PlasticClassHandleShim shim) {
        this.handle.shim = shim;
    }

    void extendShimInvoke(SwitchBlock block) {
        final String accessMethodName = this.setupMethodHandleAccess();
        block.addCase(this.methodIndex, false, new InstructionBuilderCallback(){

            @Override
            public void doBuild(InstructionBuilder builder) {
                builder.startTryCatch(new TryCatchCallback(){

                    @Override
                    public void doBlock(TryCatchBlock block) {
                        block.addTry(new InstructionBuilderCallback(){

                            @Override
                            public void doBuild(InstructionBuilder builder) {
                                for (int i = 0; i < ((PlasticMethodImpl)PlasticMethodImpl.this).description.argumentTypes.length; ++i) {
                                    String argumentType = ((PlasticMethodImpl)PlasticMethodImpl.this).description.argumentTypes[i];
                                    builder.loadArgument(2);
                                    builder.loadArrayElement(i, Object.class.getName());
                                    builder.castOrUnbox(argumentType);
                                }
                                builder.invokeVirtual(PlasticMethodImpl.this.plasticClass.className, ((PlasticMethodImpl)PlasticMethodImpl.this).description.returnType, accessMethodName, ((PlasticMethodImpl)PlasticMethodImpl.this).description.argumentTypes);
                                if (((PlasticMethodImpl)PlasticMethodImpl.this).description.returnType.equals("void")) {
                                    builder.loadNull();
                                } else {
                                    builder.boxPrimitive(((PlasticMethodImpl)PlasticMethodImpl.this).description.returnType);
                                }
                                builder.newInstance(SuccessMethodInvocationResult.class).dupe(1).swap();
                                builder.invokeConstructor(SuccessMethodInvocationResult.class, Object.class);
                                builder.returnResult();
                            }
                        });
                        for (String exceptionType : ((PlasticMethodImpl)PlasticMethodImpl.this).description.checkedExceptionTypes) {
                            block.addCatch(exceptionType, new InstructionBuilderCallback(){

                                @Override
                                public void doBuild(InstructionBuilder builder) {
                                    builder.newInstance(FailureMethodInvocationResult.class).dupe(1).swap();
                                    builder.invokeConstructor(FailureMethodInvocationResult.class, Throwable.class);
                                    builder.returnResult();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private void invokeDelegateAndReturnResult(InstructionBuilder builder, String delegateType) {
        TypeCategory typeCategory = this.plasticClass.pool.getTypeCategory(delegateType);
        if (typeCategory == TypeCategory.INTERFACE) {
            builder.invokeInterface(delegateType, this.description.returnType, this.description.methodName, this.description.argumentTypes);
        } else {
            builder.invokeVirtual(delegateType, this.description.returnType, this.description.methodName, this.description.argumentTypes);
        }
        builder.returnResult();
    }
}

