/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.plastic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.plastic.PlasticUtils;

public class MethodDescription
implements Comparable<MethodDescription> {
    public final int modifiers;
    public final String returnType;
    public final String methodName;
    public final String genericSignature;
    public final String[] argumentTypes;
    public final String[] checkedExceptionTypes;

    public MethodDescription(String returnType, String methodName, String ... argumentTypes) {
        this(1, returnType, methodName, argumentTypes, null, null);
    }

    public MethodDescription(int modifiers, String returnType, String methodName, String[] argumentTypes, String genericSignature, String[] checkedExceptionTypes) {
        assert (PlasticInternalUtils.isNonBlank(returnType));
        assert (PlasticInternalUtils.isNonBlank(methodName));
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.methodName = methodName;
        this.genericSignature = genericSignature;
        this.argumentTypes = PlasticInternalUtils.orEmpty(argumentTypes);
        this.checkedExceptionTypes = PlasticInternalUtils.orEmpty(checkedExceptionTypes);
    }

    public MethodDescription withModifiers(int newModifiers) {
        return new MethodDescription(newModifiers, this.returnType, this.methodName, this.argumentTypes, this.genericSignature, this.checkedExceptionTypes);
    }

    public MethodDescription(Method method) {
        this(method.getModifiers(), PlasticUtils.toTypeName(method.getReturnType()), method.getName(), PlasticUtils.toTypeNames(method.getParameterTypes()), null, PlasticUtils.toTypeNames(method.getExceptionTypes()));
    }

    @Override
    public int compareTo(MethodDescription o) {
        int result = this.methodName.compareTo(o.methodName);
        if (result == 0) {
            result = o.argumentTypes.length - this.argumentTypes.length;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.argumentTypes);
        result = 31 * result + Arrays.hashCode(this.checkedExceptionTypes);
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.modifiers;
        result = 31 * result + (this.genericSignature == null ? 0 : this.genericSignature.hashCode());
        result = 31 * result + this.returnType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDescription other = (MethodDescription)obj;
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.modifiers != other.modifiers) {
            return false;
        }
        if (!this.returnType.equals(other.returnType)) {
            return false;
        }
        if (!Arrays.equals(this.argumentTypes, other.argumentTypes)) {
            return false;
        }
        if (!PlasticInternalUtils.isEqual(this.genericSignature, other.genericSignature)) {
            return false;
        }
        return Arrays.equals(this.checkedExceptionTypes, other.checkedExceptionTypes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.modifiers != 0) {
            builder.append(Modifier.toString(this.modifiers)).append(" ");
        }
        builder.append(this.returnType).append(" ").append(this.methodName).append("(");
        String sep = "";
        for (String name : this.argumentTypes) {
            builder.append(sep);
            builder.append(name);
            sep = ", ";
        }
        builder.append(")");
        if (this.genericSignature != null) {
            builder.append(" <").append(this.genericSignature).append(">");
        }
        sep = " throws ";
        for (String name : this.checkedExceptionTypes) {
            builder.append(sep);
            builder.append(name);
            sep = ", ";
        }
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder(this.methodName).append("(");
        String sep = "";
        for (String name : this.argumentTypes) {
            builder.append(sep).append(name);
            sep = ", ";
        }
        return builder.append(")").toString();
    }
}

