/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IPropertySpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPropertyProxyWorker
implements EnhancementWorker {
    private List<String> _excludedPackages;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        for (Object o : spec.getPropertySpecificationNames()) {
            String name = (String)o;
            IPropertySpecification ps = spec.getPropertySpecification(name);
            this.checkProxy(op, ps);
        }
    }

    public Class extractPropertyType(Class type, String propertyName, IPropertySpecification ps) {
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor prop : props = info.getPropertyDescriptors()) {
                if (!propertyName.equals(prop.getName())) continue;
                Method m = prop.getReadMethod();
                if (m != null && !m.getGenericReturnType().getClass().getName().equals("java.lang.Class") && TypeVariable.class.isAssignableFrom(m.getGenericReturnType().getClass())) {
                    ParameterizedType ptype;
                    ps.setGeneric(true);
                    TypeVariable tvar = (TypeVariable)m.getGenericReturnType();
                    if (type.getGenericSuperclass() != null && ParameterizedType.class.isInstance(type.getGenericSuperclass()) && (ptype = (ParameterizedType)type.getGenericSuperclass()).getActualTypeArguments().length > 0) {
                        ps.setCanProxy(this.canProxyType((Class)ptype.getActualTypeArguments()[0]));
                        ps.setType(((Class)tvar.getBounds()[0]).getName());
                        return (Class)tvar.getBounds()[0];
                    }
                    return null;
                }
                if (m != null) {
                    ps.setCanProxy(this.canProxyType(m.getReturnType()));
                    ps.setType(m.getReturnType().getName());
                    return m.getReturnType();
                }
                if (m == null && prop.getWriteMethod() == null) {
                    return null;
                }
                m = prop.getWriteMethod();
                if (m.getParameterTypes().length != 1) {
                    return null;
                }
                Type genParam = m.getGenericParameterTypes()[0];
                Class<?> param = m.getParameterTypes()[0];
                if (!genParam.getClass().getName().equals("java.lang.Class") && TypeVariable.class.isAssignableFrom(genParam.getClass())) {
                    ParameterizedType ptype;
                    TypeVariable tvar = (TypeVariable)genParam;
                    ps.setGeneric(true);
                    if (type.getGenericSuperclass() != null && (ptype = (ParameterizedType)type.getGenericSuperclass()).getActualTypeArguments().length > 0) {
                        ps.setCanProxy(this.canProxyType((Class)ptype.getActualTypeArguments()[0]));
                        ps.setType(((Class)tvar.getBounds()[0]).getName());
                        return (Class)tvar.getBounds()[0];
                    }
                }
                ps.setCanProxy(this.canProxyType(param));
                ps.setType(param.getName());
                return param;
            }
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException("Error reading property " + propertyName + " from base component class : " + type, t);
        }
        return null;
    }

    boolean canProxyType(Class type) {
        if (type == null) {
            return false;
        }
        if (!EnhanceUtils.canProxyPropertyType((Class)type)) {
            return false;
        }
        for (Annotation an : type.getAnnotations()) {
            if (!this.isExcluded(an)) continue;
            return false;
        }
        return true;
    }

    void checkProxy(EnhancementOperation op, IPropertySpecification ps) {
        ps.setProxyChecked(true);
        if (!ps.isPersistent()) {
            return;
        }
        this.extractPropertyType(op.getBaseClass(), ps.getName(), ps);
    }

    boolean isExcluded(Annotation annotation) {
        for (String match : this._excludedPackages) {
            if (annotation.annotationType().getName().indexOf(match) <= -1) continue;
            return true;
        }
        return false;
    }

    public void setExcludedPackages(List<String> packages) {
        this._excludedPackages = packages;
    }
}

