/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.InjectAsset;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.enhance.InjectAssetWorker;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectAssetAnnotationWorker
implements EnhancementWorker {
    InjectAssetWorker _delegate;
    private ClassResolver _classResolver;

    InjectAssetAnnotationWorker(InjectAssetWorker delegate) {
        this._delegate = delegate;
    }

    public InjectAssetAnnotationWorker() {
        this(new InjectAssetWorker());
    }

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Class clazz = op.getBaseClass();
        ClasspathResource classResource = this.newClassResource(clazz);
        for (Method m : clazz.getMethods()) {
            if (m.getAnnotation(InjectAsset.class) == null) continue;
            this.performEnhancement(op, spec, m, AnnotationUtils.buildLocationForAnnotation(m, m.getAnnotation(InjectAsset.class), (Resource)classResource));
        }
    }

    private ClasspathResource newClassResource(Class clazz) {
        return new ClasspathResource(this._classResolver, clazz.getName().replace('.', '/'));
    }

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Location location) {
        InjectAsset as = method.getAnnotation(InjectAsset.class);
        IAssetSpecification asset = spec.getAsset(as.value());
        if (asset == null) {
            throw new ApplicationRuntimeException(AnnotationMessages.unknownAsset(as.value(), location));
        }
        String propertyName = AnnotationUtils.getPropertyName(method);
        this._delegate.injectAsset(op, as.value(), propertyName, location);
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }
}

