/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.Message;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;

public class MessageAnnotationWorker
implements MethodAnnotationEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Location location) {
        if (!method.getReturnType().equals(String.class)) {
            throw new ApplicationRuntimeException(AnnotationMessages.returnStringOnly(method.getReturnType()));
        }
        Message message = method.getAnnotation(Message.class);
        String keyName = message.value();
        if (keyName.equals("")) {
            keyName = AnnotationUtils.convertMethodNameToKeyName(method.getName());
        }
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        Object[] parameterTypes = method.getParameterTypes();
        int paramCount = Tapestry.size((Object[])parameterTypes);
        if (paramCount > 0) {
            builder.addln("java.lang.Object[] params = new java.lang.Object[{0}];", (Object)paramCount);
            for (int i = 0; i < paramCount; ++i) {
                builder.add("params[{0}] = ", (Object)i);
                if (((Class)parameterTypes[i]).isPrimitive()) {
                    builder.add("($w) ");
                }
                builder.addln("${0};", (Object)(i + 1));
            }
        }
        builder.add("return getMessages().");
        if (paramCount == 0) {
            builder.addln("getMessage(\"{0}\");", (Object)keyName);
        } else {
            builder.addln("format(\"{0}\", params);", (Object)keyName);
        }
        builder.end();
        op.addMethod(1, new MethodSignature(method), builder.toString(), location);
        if (this.isGetter(method)) {
            op.claimReadonlyProperty(AnnotationUtils.getPropertyName(method));
        }
    }

    boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
    }
}

