/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.tapestry.IPage;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.spec.ParameterSpecification;

public class ParameterAnnotationWorker
implements MethodAnnotationEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Location location) {
        if (IPage.class.isAssignableFrom(method.getDeclaringClass())) {
            throw new ApplicationRuntimeException(AnnotationMessages.invalidAnnotationInClass(Parameter.class, method.getDeclaringClass()));
        }
        Parameter parameter = method.getAnnotation(Parameter.class);
        String propertyName = AnnotationUtils.getPropertyName(method);
        boolean deprecated = method.isAnnotationPresent(Deprecated.class);
        ParameterSpecification ps = new ParameterSpecification();
        String parameterName = parameter.name();
        if (HiveMind.isBlank((String)parameterName)) {
            parameterName = propertyName;
        }
        Class propertyType = op.getPropertyType(propertyName);
        ps.setAliases(parameter.aliases());
        ps.setCache(parameter.cache());
        if (HiveMind.isNonBlank((String)parameter.defaultValue())) {
            ps.setDefaultValue(parameter.defaultValue());
        }
        ps.setDeprecated(deprecated);
        ps.setParameterName(parameterName);
        ps.setPropertyName(propertyName);
        ps.setRequired(parameter.required());
        ps.setType(propertyType.getName());
        ps.setLocation(location);
        spec.addParameter((IParameterSpecification)ps);
    }
}

