/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.func.Tuple;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.func.ZippedFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZippedFlowImpl<A, B>
implements ZippedFlow<A, B> {
    private final Flow<Tuple<A, B>> tupleFlow;

    private ZippedFlowImpl(Flow<Tuple<A, B>> tupleFlow) {
        this.tupleFlow = tupleFlow;
    }

    @Override
    public Tuple<Flow<A>, Flow<B>> unzip() {
        return Tuple.create(this.firsts(), this.seconds());
    }

    static <X, Y> ZippedFlow<X, Y> create(Flow<Tuple<X, Y>> wrappedTupleFlow) {
        assert (wrappedTupleFlow != null);
        return new ZippedFlowImpl(wrappedTupleFlow);
    }

    @Override
    public ZippedFlow<A, B> filter(Predicate<? super Tuple<A, B>> predicate) {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.filter(predicate));
    }

    @Override
    public ZippedFlow<A, B> remove(Predicate<? super Tuple<A, B>> predicate) {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.remove(predicate));
    }

    @Override
    public ZippedFlow<A, B> each(Worker<? super Tuple<A, B>> worker) {
        this.tupleFlow.each(worker);
        return this;
    }

    @Override
    public List<Tuple<A, B>> toList() {
        return this.tupleFlow.toList();
    }

    @Override
    public Set<Tuple<A, B>> toSet() {
        return this.tupleFlow.toSet();
    }

    @Override
    public ZippedFlow<A, B> reverse() {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.reverse());
    }

    @Override
    public boolean isEmpty() {
        return this.tupleFlow.isEmpty();
    }

    @Override
    public Tuple<A, B> first() {
        return (Tuple)this.tupleFlow.first();
    }

    @Override
    public ZippedFlow<A, B> rest() {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.rest());
    }

    @Override
    public int count() {
        return this.tupleFlow.count();
    }

    @Override
    public ZippedFlow<A, B> sort(Comparator<Tuple<A, B>> comparator) {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.sort(comparator));
    }

    @Override
    public ZippedFlow<A, B> take(int length) {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.take(length));
    }

    @Override
    public ZippedFlow<A, B> drop(int length) {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.drop(length));
    }

    @Override
    public ZippedFlow<A, B> concat(List<? extends Tuple<A, B>> list) {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.concat(list));
    }

    @Override
    public Iterator<Tuple<A, B>> iterator() {
        return this.tupleFlow.iterator();
    }

    @Override
    public <O> O reduce(Reducer<O, Tuple<A, B>> reducer, O initial) {
        return this.tupleFlow.reduce(reducer, initial);
    }

    @Override
    public <X, Y> ZippedFlow<X, Y> mapTuples(Mapper<Tuple<A, B>, Tuple<X, Y>> mapper) {
        return ZippedFlowImpl.create(this.tupleFlow.map(mapper));
    }

    @Override
    public Flow<A> firsts() {
        return this.tupleFlow.map(new Mapper<Tuple<A, B>, A>(){

            @Override
            public A map(Tuple<A, B> value) {
                return value.first;
            }
        });
    }

    @Override
    public ZippedFlow<A, B> removeNulls() {
        return ZippedFlowImpl.create((Flow)this.tupleFlow.removeNulls());
    }

    @Override
    public Flow<B> seconds() {
        return this.tupleFlow.map(new Mapper<Tuple<A, B>, B>(){

            @Override
            public B map(Tuple<A, B> value) {
                return value.second;
            }
        });
    }

    @Override
    public ZippedFlow<A, B> filterOnFirst(final Predicate<? super A> predicate) {
        assert (predicate != null);
        return this.filter(new Predicate<Tuple<A, B>>(){

            @Override
            public boolean accept(Tuple<A, B> element) {
                return predicate.accept(element.first);
            }
        });
    }

    @Override
    public ZippedFlow<A, B> filterOnSecond(final Predicate<? super B> predicate) {
        assert (predicate != null);
        return this.filter(new Predicate<Tuple<A, B>>(){

            @Override
            public boolean accept(Tuple<A, B> element) {
                return predicate.accept(element.second);
            }
        });
    }

    @Override
    public ZippedFlow<A, B> removeOnFirst(Predicate<? super A> predicate) {
        assert (predicate != null);
        return this.filterOnFirst(F.not(predicate));
    }

    @Override
    public ZippedFlow<A, B> removeOnSecond(Predicate<? super B> predicate) {
        assert (predicate != null);
        return this.filterOnSecond(F.not(predicate));
    }

    @Override
    public Map<A, B> toMap() {
        final HashMap result = new HashMap();
        this.tupleFlow.each(new Worker<Tuple<A, B>>(){

            @Override
            public void work(Tuple<A, B> value) {
                result.put(value.first, value.second);
            }
        });
        return result;
    }
}

