/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.ioc.internal.services.FilterMethodAnalyzer;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BridgeBuilder<S, F> {
    private final Logger logger;
    private final Class<S> serviceInterface;
    private final Class<F> filterInterface;
    private final FilterMethodAnalyzer filterMethodAnalyzer;
    private final PlasticProxyFactory proxyFactory;
    private ClassInstantiator<S> instantiator;

    BridgeBuilder(Logger logger, Class<S> serviceInterface, Class<F> filterInterface, PlasticProxyFactory proxyFactory) {
        this.logger = logger;
        this.serviceInterface = serviceInterface;
        this.filterInterface = filterInterface;
        this.proxyFactory = proxyFactory;
        this.filterMethodAnalyzer = new FilterMethodAnalyzer(serviceInterface);
    }

    public S instantiateBridge(S nextBridge, F filter) {
        if (this.instantiator == null) {
            this.createInstantiator();
        }
        return (S)this.instantiator.with(this.filterInterface, filter).with(this.serviceInterface, nextBridge).newInstance();
    }

    private void createInstantiator() {
        this.instantiator = this.proxyFactory.createProxy(this.serviceInterface, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                PlasticField filterField = plasticClass.introduceField(BridgeBuilder.this.filterInterface, "filter").injectFromInstanceContext();
                PlasticField nextField = plasticClass.introduceField(BridgeBuilder.this.serviceInterface, "next").injectFromInstanceContext();
                BridgeBuilder.this.processMethods(plasticClass, filterField, nextField);
                plasticClass.addToString(String.format("<PipelineBridge from %s to %s>", BridgeBuilder.this.serviceInterface.getName(), BridgeBuilder.this.filterInterface.getName()));
            }
        });
    }

    private void processMethods(PlasticClass plasticClass, PlasticField filterField, PlasticField nextField) {
        List serviceMethods = CollectionFactory.newList();
        List filterMethods = CollectionFactory.newList();
        MethodIterator mi = new MethodIterator(this.serviceInterface);
        while (mi.hasNext()) {
            serviceMethods.add(mi.next());
        }
        mi = new MethodIterator(this.filterInterface);
        while (mi.hasNext()) {
            filterMethods.add(mi.next());
        }
        while (!serviceMethods.isEmpty()) {
            MethodSignature ms = (MethodSignature)serviceMethods.remove(0);
            this.addBridgeMethod(plasticClass, filterField, nextField, ms, filterMethods);
        }
        this.reportExtraFilterMethods(filterMethods);
    }

    private void reportExtraFilterMethods(List filterMethods) {
        for (MethodSignature ms : filterMethods) {
            this.logger.error(ServiceMessages.extraFilterMethod(ms, this.filterInterface, this.serviceInterface));
        }
    }

    private void addBridgeMethod(PlasticClass plasticClass, PlasticField filterField, PlasticField nextField, final MethodSignature ms, List filterMethods) {
        PlasticMethod method = plasticClass.introduceMethod(ms.getMethod());
        Iterator i = filterMethods.iterator();
        while (i.hasNext()) {
            MethodSignature fms = (MethodSignature)i.next();
            int position = this.filterMethodAnalyzer.findServiceInterfacePosition(ms, fms);
            if (position < 0) continue;
            this.bridgeServiceMethodToFilterMethod(method, filterField, nextField, position, ms, fms);
            i.remove();
            return;
        }
        method.changeImplementation(new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                String message = ServiceMessages.unmatchedServiceMethod(ms, BridgeBuilder.this.filterInterface);
                BridgeBuilder.this.logger.error(message);
                builder.throwException(RuntimeException.class, message);
            }
        });
    }

    private void bridgeServiceMethodToFilterMethod(PlasticMethod method, final PlasticField filterField, final PlasticField nextField, final int position, MethodSignature ms, final MethodSignature fms) {
        method.changeImplementation(new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.loadThis().getField(filterField);
                int argumentIndex = 0;
                for (int i = 0; i < fms.getParameterTypes().length; ++i) {
                    if (i == position) {
                        builder.loadThis().getField(nextField);
                        continue;
                    }
                    builder.loadArgument(argumentIndex++);
                }
                builder.invoke(fms.getMethod()).returnResult();
            }
        });
    }
}

