/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.tree.AbstractInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.InsnList;
import org.apache.tapestry5.internal.plastic.asm.tree.LineNumberNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.services.PlasticClassListenerLogger;
import org.apache.tapestry5.ioc.internal.services.StringLocation;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassListener;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticManager;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasticProxyFactoryImpl
implements PlasticProxyFactory {
    private final PlasticManager manager;

    public PlasticProxyFactoryImpl(ClassLoader parentClassLoader, Logger logger) {
        this(PlasticManager.withClassLoader((ClassLoader)parentClassLoader).create(), logger);
    }

    public PlasticProxyFactoryImpl(PlasticManager manager, Logger logger) {
        assert (manager != null);
        this.manager = manager;
        if (logger != null) {
            manager.addPlasticClassListener((PlasticClassListener)new PlasticClassListenerLogger(logger));
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.manager.getClassLoader();
    }

    @Override
    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, PlasticClassTransformer callback) {
        return this.manager.createProxy(interfaceType, callback);
    }

    public PlasticClassTransformation createProxyTransformation(Class interfaceType) {
        return this.manager.createProxyTransformation(interfaceType);
    }

    @Override
    public <T> T createProxy(final Class<T> interfaceType, final ObjectCreator<T> creator, final String description) {
        assert (creator != null);
        assert (InternalUtils.isNonBlank(description));
        ClassInstantiator<T> instantiator = this.createProxy(interfaceType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                final PlasticField objectCreatorField = plasticClass.introduceField(ObjectCreator.class, "creator").inject((Object)creator);
                PlasticMethod delegateMethod = plasticClass.introducePrivateMethod(interfaceType.getName(), "delegate", null, null);
                delegateMethod.changeImplementation(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(objectCreatorField);
                        builder.invoke(ObjectCreator.class, Object.class, "createObject", new Class[0]);
                        builder.checkcast(interfaceType).returnResult();
                    }
                });
                for (Method method : interfaceType.getMethods()) {
                    plasticClass.introduceMethod(method).delegateTo(delegateMethod);
                }
                plasticClass.addToString(description);
            }
        });
        return interfaceType.cast(instantiator.newInstance());
    }

    private ClassNode readClassNode(Class clazz) {
        byte[] bytecode = PlasticInternalUtils.readBytecodeForClass((ClassLoader)this.manager.getClassLoader(), (String)clazz.getName(), (boolean)false);
        return bytecode == null ? null : PlasticInternalUtils.convertBytecodeToClassNode((byte[])bytecode);
    }

    @Override
    public Location getMethodLocation(Method method) {
        return this.getMemberLocation(method, method.getName(), Type.getMethodDescriptor((Method)method), InternalUtils.asString(method));
    }

    @Override
    public Location getConstructorLocation(Constructor constructor) {
        StringBuilder builder = new StringBuilder(constructor.getDeclaringClass().getName()).append("(");
        String sep = "";
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            builder.append(sep);
            builder.append(parameterType.getSimpleName());
            sep = ", ";
        }
        builder.append(")");
        String constructorDescription = builder.toString();
        return this.getMemberLocation(constructor, "<init>", Type.getConstructorDescriptor((Constructor)constructor), constructorDescription);
    }

    public Location getMemberLocation(Member member, String methodName, String memberTypeDesc, String textDescription) {
        ClassNode classNode = this.readClassNode(member.getDeclaringClass());
        if (classNode == null) {
            throw new RuntimeException(String.format("Unable to read class file for %s (to gather line number information).", textDescription));
        }
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(methodName) || !mn.desc.equals(memberTypeDesc)) continue;
            int lineNumber = this.findFirstLineNumber(mn.instructions);
            if (lineNumber < 1) break;
            String description = String.format("%s (at %s:%d)", textDescription, classNode.sourceFile, lineNumber);
            return new StringLocation(description, lineNumber);
        }
        return new StringLocation(textDescription, 0);
    }

    private int findFirstLineNumber(InsnList instructions) {
        for (AbstractInsnNode node = instructions.getFirst(); node != null; node = node.getNext()) {
            if (!(node instanceof LineNumberNode)) continue;
            return ((LineNumberNode)node).line;
        }
        return -1;
    }

    public void addPlasticClassListener(PlasticClassListener listener) {
        this.manager.addPlasticClassListener(listener);
    }

    public void removePlasticClassListener(PlasticClassListener listener) {
        this.manager.removePlasticClassListener(listener);
    }
}

