/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.LockSupport;
import org.apache.tapestry5.ioc.util.LocalizedNameGenerator;

public abstract class AbstractResource
extends LockSupport
implements Resource {
    private final String path;
    private boolean exists;
    private boolean existsComputed;
    private Localization firstLocalization;

    protected AbstractResource(String path) {
        assert (path != null);
        this.path = path;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getFile() {
        int slashx = this.path.lastIndexOf(47);
        return this.path.substring(slashx + 1);
    }

    public final String getFolder() {
        int slashx = this.path.lastIndexOf(47);
        return slashx < 0 ? "" : this.path.substring(0, slashx);
    }

    public final Resource forFile(String relativePath) {
        assert (relativePath != null);
        StringBuilder builder = new StringBuilder(this.getFolder());
        for (String term : relativePath.split("/")) {
            if (term.equals("") || term.equals(".")) continue;
            if (term.equals("..")) {
                int slashx = builder.lastIndexOf("/");
                builder.setLength(slashx);
                continue;
            }
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(term);
        }
        return this.createResource(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Resource forLocale(Locale locale) {
        try {
            this.acquireReadLock();
            Localization l = this.firstLocalization;
            while (l != null) {
                if (l.locale.equals(locale)) {
                    Resource resource = l.resource;
                    return resource;
                }
                l = l.next;
            }
            Resource resource = this.populateLocalizationCache(locale);
            return resource;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource populateLocalizationCache(Locale locale) {
        try {
            this.upgradeReadLockToWriteLock();
            Localization l = this.firstLocalization;
            while (l != null) {
                if (l.locale.equals(locale)) {
                    Resource resource = l.resource;
                    return resource;
                }
                l = l.next;
            }
            Resource result = this.findLocalizedResource(locale);
            this.firstLocalization = new Localization(locale, result, this.firstLocalization);
            Resource resource = result;
            return resource;
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    private Resource findLocalizedResource(Locale locale) {
        for (String path : new LocalizedNameGenerator(this.path, locale)) {
            Resource potential = this.createResource(path);
            if (!potential.exists()) continue;
            return potential;
        }
        return null;
    }

    public final Resource withExtension(String extension) {
        assert (InternalUtils.isNonBlank(extension));
        int dotx = this.path.lastIndexOf(46);
        if (dotx < 0) {
            return this.createResource(this.path + "." + extension);
        }
        return this.createResource(this.path.substring(0, dotx + 1) + extension);
    }

    private Resource createResource(String path) {
        if (this.path.equals(path)) {
            return this;
        }
        return this.newResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        try {
            this.acquireReadLock();
            if (!this.existsComputed) {
                this.computeExists();
            }
            boolean bl = this.exists;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeExists() {
        try {
            this.upgradeReadLockToWriteLock();
            if (!this.existsComputed) {
                this.exists = this.toURL() != null;
                this.existsComputed = true;
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    public InputStream openStream() throws IOException {
        URL url = this.toURL();
        if (url == null) {
            return null;
        }
        return new BufferedInputStream(url.openStream());
    }

    protected abstract Resource newResource(String var1);

    private class Localization {
        final Locale locale;
        final Resource resource;
        final Localization next;

        private Localization(Locale locale, Resource resource, Localization next) {
            this.locale = locale;
            this.resource = resource;
            this.next = next;
        }
    }
}

