/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services.cron;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ParallelExecutor;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.cron.PeriodicExecutor;
import org.apache.tapestry5.ioc.services.cron.PeriodicJob;
import org.apache.tapestry5.ioc.services.cron.Schedule;
import org.slf4j.Logger;

public class PeriodicExecutorImpl
implements PeriodicExecutor,
Runnable {
    private final ParallelExecutor parallelExecutor;
    private final Logger logger;
    private final List<Job> jobs = CollectionFactory.newList();
    private final Thread thread = new Thread((Runnable)this, "Tapestry PeriodicExecutor");
    private transient boolean shutdown;
    private static final long FIVE_MINUTES = 300000L;
    private final AtomicInteger jobIdAllocator = new AtomicInteger();
    private final Lock jobLock = new ReentrantLock();

    public PeriodicExecutorImpl(ParallelExecutor parallelExecutor, Logger logger) {
        this.parallelExecutor = parallelExecutor;
        this.logger = logger;
    }

    @PostInjection
    public void start(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                PeriodicExecutorImpl.this.registryDidShutdown();
            }
        });
        this.thread.start();
    }

    void removeJob(Job job) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removing " + job);
        }
        try {
            this.jobLock.lock();
            this.jobs.remove(job);
        }
        finally {
            this.jobLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodicJob addJob(Schedule schedule, String name, Runnable job) {
        assert (schedule != null);
        assert (name != null);
        assert (job != null);
        Job periodicJob = new Job(schedule, name, job);
        try {
            this.jobLock.lock();
            this.jobs.add(periodicJob);
        }
        finally {
            this.jobLock.unlock();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added " + periodicJob);
        }
        this.thread.interrupt();
        return periodicJob;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            long nextExecution = this.executeCurrentBatch();
            try {
                long delay = nextExecution - System.currentTimeMillis();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Sleeping for %,d ms", delay));
                }
                if (delay <= 0L) continue;
                Thread.sleep(delay);
            }
            catch (InterruptedException ex) {
                this.logger.trace("Interrupted");
            }
        }
    }

    private void registryDidShutdown() {
        this.shutdown = true;
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeCurrentBatch() {
        long now = System.currentTimeMillis();
        long nextExecution = now + 300000L;
        try {
            this.jobLock.lock();
            HashSet<Job> jobsToCancel = null;
            for (Job job : this.jobs) {
                if (job.isExecuting()) continue;
                long jobNextExecution = job.getNextExecution();
                if (jobNextExecution <= 0L) {
                    if (jobsToCancel == null) {
                        jobsToCancel = new HashSet<Job>();
                    }
                    jobsToCancel.add(job);
                    continue;
                }
                if (jobNextExecution <= now) {
                    job.start();
                    continue;
                }
                nextExecution = Math.min(nextExecution, jobNextExecution);
            }
            if (jobsToCancel != null) {
                for (Job job : jobsToCancel) {
                    job.cancel();
                }
            }
        }
        finally {
            this.jobLock.unlock();
        }
        return nextExecution;
    }

    private class Job
    implements PeriodicJob,
    Invokable<Void> {
        final int jobId;
        private final Schedule schedule;
        private final String name;
        private final Runnable runnableJob;
        private boolean executing;
        private boolean canceled;
        private long nextExecution;

        public Job(Schedule schedule, String name, Runnable runnableJob) {
            this.jobId = PeriodicExecutorImpl.this.jobIdAllocator.incrementAndGet();
            this.schedule = schedule;
            this.name = name;
            this.runnableJob = runnableJob;
            this.nextExecution = schedule.firstExecution();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public long getNextExecution() {
            try {
                PeriodicExecutorImpl.this.jobLock.lock();
                long l = this.nextExecution;
                return l;
            }
            finally {
                PeriodicExecutorImpl.this.jobLock.unlock();
            }
        }

        @Override
        public boolean isExecuting() {
            try {
                PeriodicExecutorImpl.this.jobLock.lock();
                boolean bl = this.executing;
                return bl;
            }
            finally {
                PeriodicExecutorImpl.this.jobLock.unlock();
            }
        }

        @Override
        public boolean isCanceled() {
            try {
                PeriodicExecutorImpl.this.jobLock.lock();
                boolean bl = this.canceled;
                return bl;
            }
            finally {
                PeriodicExecutorImpl.this.jobLock.unlock();
            }
        }

        @Override
        public void cancel() {
            try {
                PeriodicExecutorImpl.this.jobLock.lock();
                this.canceled = true;
                if (!this.executing) {
                    PeriodicExecutorImpl.this.removeJob(this);
                }
            }
            finally {
                PeriodicExecutorImpl.this.jobLock.unlock();
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PeriodicJob[#").append(this.jobId);
            builder.append(", (").append(this.name).append(')');
            if (this.executing) {
                builder.append(", executing");
            }
            if (this.canceled) {
                builder.append(", canceled");
            } else {
                builder.append(String.format(", next execution %Tk:%<TM:%<TS+%<TL", this.nextExecution));
            }
            return builder.append(']').toString();
        }

        void start() {
            try {
                PeriodicExecutorImpl.this.jobLock.lock();
                this.executing = true;
                this.nextExecution = this.schedule.nextExecution(this.nextExecution);
                PeriodicExecutorImpl.this.parallelExecutor.invoke(this);
            }
            finally {
                PeriodicExecutorImpl.this.jobLock.unlock();
            }
            if (PeriodicExecutorImpl.this.logger.isTraceEnabled()) {
                PeriodicExecutorImpl.this.logger.trace(this + " sent for execution");
            }
        }

        void cleanupAfterExecution() {
            try {
                if (PeriodicExecutorImpl.this.logger.isTraceEnabled()) {
                    PeriodicExecutorImpl.this.logger.trace(this + " execution complete");
                }
                this.executing = false;
                if (this.canceled) {
                    PeriodicExecutorImpl.this.removeJob(this);
                } else {
                    PeriodicExecutorImpl.this.thread.interrupt();
                }
            }
            finally {
                PeriodicExecutorImpl.this.jobLock.unlock();
            }
        }

        @Override
        public Void invoke() {
            if (PeriodicExecutorImpl.this.logger.isDebugEnabled()) {
                PeriodicExecutorImpl.this.logger.debug(String.format("Executing job #%d (%s)", this.jobId, this.name));
            }
            try {
                this.runnableJob.run();
            }
            finally {
                this.cleanupAfterExecution();
            }
            return null;
        }
    }
}

