/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.internal.plastic.ClassLoaderDelegate;
import org.apache.tapestry5.internal.plastic.PlasticClassLoader;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.asm.ClassReader;
import org.apache.tapestry5.internal.plastic.asm.ClassVisitor;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ReloadAware;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.slf4j.Logger;

public abstract class AbstractReloadableObjectCreator
implements ObjectCreator,
UpdateListener,
ClassLoaderDelegate {
    private final ClassLoader baseClassLoader;
    private final String implementationClassName;
    private final Logger logger;
    private final OperationTracker tracker;
    private final URLChangeTracker changeTracker = new URLChangeTracker();
    private final PlasticProxyFactory proxyFactory;
    private final Set<String> classesToLoad = CollectionFactory.newSet();
    private Object instance;
    private boolean firstTime = true;
    private PlasticClassLoader loader;

    protected AbstractReloadableObjectCreator(PlasticProxyFactory proxyFactory, ClassLoader baseClassLoader, String implementationClassName, Logger logger, OperationTracker tracker) {
        this.proxyFactory = proxyFactory;
        this.baseClassLoader = baseClassLoader;
        this.implementationClassName = implementationClassName;
        this.logger = logger;
        this.tracker = tracker;
    }

    @Override
    public synchronized void checkForUpdates() {
        if (this.instance == null || !this.changeTracker.containsChanges()) {
            return;
        }
        this.logger.debug("Implementation class {} has changed and will be reloaded on next use.", (Object)this.implementationClassName);
        this.changeTracker.clear();
        this.loader = null;
        this.proxyFactory.clearCache();
        boolean reloadNow = this.informInstanceOfReload();
        this.instance = reloadNow ? this.createInstance() : null;
    }

    private boolean informInstanceOfReload() {
        if (this.instance instanceof ReloadAware) {
            ReloadAware ra = (ReloadAware)this.instance;
            return ra.shutdownImplementationForReload();
        }
        return false;
    }

    public synchronized Object createObject() {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
        return this.instance;
    }

    private Object createInstance() {
        return this.tracker.invoke(String.format("Reloading class %s.", this.implementationClassName), new Invokable<Object>(){

            @Override
            public Object invoke() {
                Class reloadedClass = AbstractReloadableObjectCreator.this.reloadImplementationClass();
                return AbstractReloadableObjectCreator.this.createInstance(reloadedClass);
            }
        });
    }

    protected abstract Object createInstance(Class var1);

    private Class reloadImplementationClass() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} class {}.", (Object)(this.firstTime ? "Loading" : "Reloading"), (Object)this.implementationClassName);
        }
        this.loader = new PlasticClassLoader(this.baseClassLoader, (ClassLoaderDelegate)this);
        this.classesToLoad.clear();
        this.add(this.implementationClassName);
        try {
            Class result = this.loader.loadClass(this.implementationClassName);
            this.firstTime = false;
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Unable to %s class %s: %s", this.firstTime ? "load" : "reload", this.implementationClassName, ExceptionUtils.toMessage((Throwable)ex)), ex);
        }
    }

    private void add(String className) {
        if (!this.classesToLoad.contains(className)) {
            this.logger.debug("Marking class {} to be (re-)loaded", (Object)className);
            this.classesToLoad.add(className);
        }
    }

    public boolean shouldInterceptClassLoading(String className) {
        return this.classesToLoad.contains(className);
    }

    public Class<?> loadAndTransformClass(String className) throws ClassNotFoundException {
        Class<?> result;
        this.logger.debug("BEGIN Analyzing {}", (Object)className);
        try {
            result = this.doClassLoad(className);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(String.format("Unable to analyze and load class %s: %s", className, ExceptionUtils.toMessage((Throwable)ex)), ex);
        }
        this.trackClassFileChanges(className);
        this.logger.debug("  END Analyzing {}", (Object)className);
        return result;
    }

    public Class<?> doClassLoad(String className) throws IOException {
        int length;
        ClassVisitor analyzer = new ClassVisitor(589824){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                String path = superName + ".class";
                URL url = AbstractReloadableObjectCreator.this.baseClassLoader.getResource(path);
                if (AbstractReloadableObjectCreator.this.isFileURL(url)) {
                    AbstractReloadableObjectCreator.this.add(PlasticInternalUtils.toClassName((String)superName));
                }
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (outerName == null || AbstractReloadableObjectCreator.this.classesToLoad.contains(PlasticInternalUtils.toClassName((String)outerName))) {
                    AbstractReloadableObjectCreator.this.add(PlasticInternalUtils.toClassName((String)name));
                }
            }
        };
        String path = PlasticInternalUtils.toClassPath((String)className);
        InputStream stream = this.baseClassLoader.getResourceAsStream(path);
        assert (stream != null);
        ByteArrayOutputStream classBuffer = new ByteArrayOutputStream(5000);
        byte[] buffer = new byte[5000];
        while ((length = stream.read(buffer)) >= 0) {
            classBuffer.write(buffer, 0, length);
        }
        stream.close();
        byte[] bytecode = classBuffer.toByteArray();
        new ClassReader((InputStream)new ByteArrayInputStream(bytecode)).accept(analyzer, 7);
        return this.loader.defineClassWithBytecode(className, bytecode);
    }

    private void trackClassFileChanges(String className) {
        if (this.isInnerClassName(className)) {
            return;
        }
        String path = PlasticInternalUtils.toClassPath((String)className);
        URL url = this.baseClassLoader.getResource(path);
        if (this.isFileURL(url)) {
            this.changeTracker.add(url);
        }
    }

    private boolean isFileURL(URL url) {
        return url != null && url.getProtocol().equals("file");
    }

    private boolean isInnerClassName(String className) {
        return className.indexOf(36) >= 0;
    }
}

