/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.json.JSONPrintSession;
import org.apache.tapestry5.json.JSONTokener;

public final class JSONArray
extends JSONCollection
implements Iterable<Object> {
    private final List<Object> list = new ArrayList<Object>();

    public JSONArray() {
    }

    public JSONArray(String text) {
        JSONTokener tokener = new JSONTokener(text);
        this.parse(tokener);
    }

    public JSONArray(Object ... values) {
        for (Object value : values) {
            this.put(value);
        }
    }

    public static JSONArray from(Iterable<?> iterable) {
        return new JSONArray().putAll(iterable);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    JSONArray(JSONTokener tokenizer) {
        assert (tokenizer != null);
        this.parse(tokenizer);
    }

    private void parse(JSONTokener tokenizer) {
        if (tokenizer.nextClean() != '[') {
            throw tokenizer.syntaxError("A JSONArray text must start with '['");
        }
        if (tokenizer.nextClean() == ']') {
            return;
        }
        tokenizer.back();
        block4: while (true) {
            if (tokenizer.nextClean() == ',') {
                tokenizer.back();
                this.list.add(JSONObject.NULL);
            } else {
                tokenizer.back();
                this.list.add(tokenizer.nextValue());
            }
            switch (tokenizer.nextClean()) {
                case ',': 
                case ';': {
                    if (tokenizer.nextClean() == ']') {
                        return;
                    }
                    tokenizer.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw tokenizer.syntaxError("Expected a ',' or ']'");
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    public boolean getBoolean(int index) {
        Object value = this.get(index);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String asString = (String)value;
            if (asString.equalsIgnoreCase("false")) {
                return false;
            }
            if (asString.equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new RuntimeException("JSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) {
        Object value = this.get(index);
        try {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.valueOf((String)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("JSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new RuntimeException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new RuntimeException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public long getLong(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return this.get(index) == JSONObject.NULL;
    }

    public int length() {
        return this.list.size();
    }

    public JSONArray put(Object value) {
        JSONObject.testValidity(value);
        this.list.add(value);
        return this;
    }

    public JSONArray put(int index, Object value) {
        assert (value != null);
        if (index < 0) {
            throw new RuntimeException("JSONArray[" + index + "] not found.");
        }
        JSONObject.testValidity(value);
        if (index < this.length()) {
            this.list.set(index, value);
        } else {
            while (index != this.length()) {
                this.list.add(JSONObject.NULL);
            }
            this.list.add(value);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONArray)) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        return this.list.equals(other.list);
    }

    @Override
    void print(JSONPrintSession session) {
        session.printSymbol('[');
        session.indent();
        boolean comma = false;
        for (Object value : this.list) {
            if (comma) {
                session.printSymbol(',');
            }
            session.newline();
            JSONObject.printValue(session, value);
            comma = true;
        }
        session.outdent();
        if (comma) {
            session.newline();
        }
        session.printSymbol(']');
    }

    public JSONArray putAll(Iterable<?> collection) {
        if (collection != null) {
            for (Object o : collection) {
                this.put(o);
            }
        }
        return this;
    }

    public List<Object> toList() {
        return Collections.unmodifiableList(this.list);
    }
}

