/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.json.JSON;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.json.JSONPrintSession;
import org.apache.tapestry5.json.JSONTokener;

public final class JSONArray
extends JSONCollection
implements Iterable<Object> {
    private final List<Object> values;

    public JSONArray() {
        this.values = new ArrayList<Object>();
    }

    JSONArray(JSONTokener readFrom) {
        Object object = readFrom.nextValue(JSONArray.class);
        if (!(object instanceof JSONArray)) {
            throw JSON.typeMismatch(object, "JSONArray");
        }
        this.values = ((JSONArray)object).values;
    }

    public JSONArray(String json) {
        this(new JSONTokener(json));
    }

    public JSONArray(Object ... values) {
        this();
        for (int i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    public static JSONArray from(Iterable<?> iterable) {
        return new JSONArray().putAll(iterable);
    }

    public int length() {
        return this.values.size();
    }

    public JSONArray put(Object value) {
        JSONObject.testValidity(value);
        this.values.add(value);
        return this;
    }

    void checkedPut(Object value) {
        JSONObject.testValidity(value);
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.put(value);
    }

    public JSONArray put(int index, Object value) {
        if (index < 0) {
            throw new RuntimeException("JSONArray[" + index + "] not found.");
        }
        JSONObject.testValidity(value);
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        while (this.values.size() <= index) {
            this.values.add(null);
        }
        this.values.set(index, value);
        return this;
    }

    public boolean isNull(int index) {
        Object value = this.values.get(index);
        return value == null || value == JSONObject.NULL;
    }

    public Object get(int index) {
        try {
            Object value = this.values.get(index);
            if (value == null) {
                throw new RuntimeException("Value at " + index + " is null.");
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Index " + index + " out of range [0.." + this.values.size() + ")");
        }
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        return this.values.remove(index);
    }

    public boolean getBoolean(int index) {
        Object object = this.get(index);
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSON.typeMismatch(true, index, object, "Boolean");
        }
        return result;
    }

    public double getDouble(int index) {
        Object object = this.get(index);
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSON.typeMismatch(true, index, object, "number");
        }
        return result;
    }

    public int getInt(int index) {
        Object object = this.get(index);
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSON.typeMismatch(true, index, object, "int");
        }
        return result;
    }

    public long getLong(int index) {
        Object object = this.get(index);
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSON.typeMismatch(true, index, object, "long");
        }
        return result;
    }

    public String getString(int index) {
        Object object = this.get(index);
        String result = JSON.toString(object);
        if (result == null) {
            throw JSON.typeMismatch(true, index, object, "String");
        }
        return result;
    }

    public JSONArray getJSONArray(int index) {
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSON.typeMismatch(true, index, object, "JSONArray");
    }

    public JSONObject getJSONObject(int index) {
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSON.typeMismatch(true, index, object, "JSONObject");
    }

    public boolean equals(Object o) {
        return o instanceof JSONArray && ((JSONArray)o).values.equals(this.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    void print(JSONPrintSession session) {
        session.printSymbol('[');
        session.indent();
        boolean comma = false;
        for (Object value : this.values) {
            if (comma) {
                session.printSymbol(',');
            }
            session.newline();
            JSONObject.printValue(session, value);
            comma = true;
        }
        session.outdent();
        if (comma) {
            session.newline();
        }
        session.printSymbol(']');
    }

    public JSONArray putAll(Iterable<?> collection) {
        if (collection != null) {
            for (Object o : collection) {
                this.put(o);
            }
        }
        return this;
    }

    public List<Object> toList() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }
}

