/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spring;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.spring.SpringMessages;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpringObjectProvider
implements ObjectProvider {
    private final WebApplicationContext _context;
    private final Map<String, String> _beanNames = CollectionFactory.newCaseInsensitiveMap();

    public SpringObjectProvider(Log log, WebApplicationContext context) {
        this._context = context;
        for (String name : this._context.getBeanDefinitionNames()) {
            this._beanNames.put(name, name);
        }
        log.info((Object)SpringMessages.contextStartup(this._beanNames.keySet()));
    }

    public <T> T provide(String expression, Class<T> objectType, ServiceLocator locator) {
        String effectiveName = this._beanNames.containsKey(expression) ? this._beanNames.get(expression) : expression;
        try {
            Object raw = this._context.getBean(effectiveName, objectType);
            return objectType.cast(raw);
        }
        catch (Exception ex) {
            throw new RuntimeException(SpringMessages.beanAccessFailure(effectiveName, objectType, ex), ex);
        }
    }
}

