/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.spring;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.apache.tapestry5.internal.AbstractContributionDef;
import org.apache.tapestry5.internal.spring.CustomizingContextLoader;
import org.apache.tapestry5.internal.spring.SpringBeanServiceDef;
import org.apache.tapestry5.internal.spring.StaticObjectCreator;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.spring.ApplicationContextCustomizer;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringModuleDef
implements ModuleDef {
    static final String SERVICE_ID = "ApplicationContext";
    private final Map<String, ServiceDef> services = CollectionFactory.newMap();
    private final boolean compatibilityMode;
    private final AtomicBoolean applicationContextCreated = new AtomicBoolean(false);
    private final ServletContext servletContext;

    private ConfigurableWebApplicationContext locateExternalContext() {
        ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (context == null) {
            throw new NullPointerException(String.format("No Spring ApplicationContext stored in the ServletContext as attribute '%s'. You should either re-enable Tapestry as the creator of the ApplicationContext, or add a Spring ContextLoaderListener to web.xml.", WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE));
        }
        this.applicationContextCreated.set(true);
        return context;
    }

    public SpringModuleDef(ServletContext servletContext) {
        ConfigurableWebApplicationContext externalContext;
        this.servletContext = servletContext;
        this.compatibilityMode = Boolean.parseBoolean(servletContext.getInitParameter("tapestry.use-external-spring-context"));
        ConfigurableWebApplicationContext configurableWebApplicationContext = externalContext = this.compatibilityMode ? this.locateExternalContext() : null;
        if (this.compatibilityMode) {
            this.addServiceDefsForSpringBeans((ApplicationContext)externalContext);
        }
        ServiceDef applicationContextServiceDef = new ServiceDef((ApplicationContext)externalContext){
            final /* synthetic */ ApplicationContext val$externalContext;
            {
                this.val$externalContext = applicationContext;
            }

            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                if (SpringModuleDef.this.compatibilityMode) {
                    return new StaticObjectCreator(this.val$externalContext, "externally configured Spring ApplicationContext");
                }
                ApplicationContextCustomizer customizer = (ApplicationContextCustomizer)resources.getService("ApplicationContextCustomizer", ApplicationContextCustomizer.class);
                return SpringModuleDef.this.constructObjectCreatorForApplicationContext(resources, customizer);
            }

            public String getServiceId() {
                return SpringModuleDef.SERVICE_ID;
            }

            public Set<Class> getMarkers() {
                return Collections.emptySet();
            }

            public Class getServiceInterface() {
                return SpringModuleDef.this.compatibilityMode ? this.val$externalContext.getClass() : ConfigurableWebApplicationContext.class;
            }

            public String getServiceScope() {
                return "singleton";
            }

            public boolean isEagerLoad() {
                return false;
            }
        };
        this.services.put(SERVICE_ID, applicationContextServiceDef);
    }

    private void addServiceDefsForSpringBeans(ApplicationContext context) {
        for (String beanName : BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)context)) {
            String trueName = beanName.startsWith("&") ? beanName.substring(1) : beanName;
            this.services.put(trueName, (ServiceDef)new SpringBeanServiceDef(trueName, context));
        }
    }

    private ObjectCreator constructObjectCreatorForApplicationContext(final ServiceBuilderResources resources, @Primary ApplicationContextCustomizer customizer) {
        final CustomizingContextLoader loader = new CustomizingContextLoader(customizer);
        final RegistryShutdownListener shutdownListener = new RegistryShutdownListener(){

            public void registryDidShutdown() {
                loader.closeWebApplicationContext(SpringModuleDef.this.servletContext);
            }
        };
        final RegistryShutdownHub shutdownHub = (RegistryShutdownHub)resources.getService(RegistryShutdownHub.class);
        return new ObjectCreator(){

            public Object createObject() {
                return resources.getTracker().invoke("Creating Spring ApplicationContext via ContextLoader", (Invokable)new Invokable<Object>(){

                    public Object invoke() {
                        resources.getLogger().info(String.format("Starting Spring (version %s)", SpringVersion.getVersion()));
                        WebApplicationContext context = loader.initWebApplicationContext(SpringModuleDef.this.servletContext);
                        shutdownHub.addRegistryShutdownListener(shutdownListener);
                        SpringModuleDef.this.applicationContextCreated.set(true);
                        return context;
                    }
                });
            }

            public String toString() {
                return "ObjectCreator for Spring ApplicationContext";
            }
        };
    }

    public Class getBuilderClass() {
        return null;
    }

    public Set<ContributionDef> getContributionDefs() {
        ContributionDef def = this.createContributionToMasterObjectProvider();
        return CollectionFactory.newSet((Object[])new ContributionDef[]{def});
    }

    private ContributionDef createContributionToMasterObjectProvider() {
        AbstractContributionDef def = new AbstractContributionDef(){

            public String getServiceId() {
                return "MasterObjectProvider";
            }

            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, OrderedConfiguration configuration) {
                final OperationTracker tracker = resources.getTracker();
                final ApplicationContext context = (ApplicationContext)resources.getService(SpringModuleDef.SERVICE_ID, ApplicationContext.class);
                final ObjectProvider springBeanProvider = new ObjectProvider(){

                    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                        Map beanMap = context.getBeansOfType(objectType);
                        switch (beanMap.size()) {
                            case 0: {
                                return null;
                            }
                            case 1: {
                                Object bean = beanMap.values().iterator().next();
                                return objectType.cast(bean);
                            }
                        }
                        String message = String.format("Spring context contains %d beans assignable to type %s: %s.", beanMap.size(), ClassFabUtils.toJavaClassName(objectType), InternalUtils.joinSorted(beanMap.keySet()));
                        throw new IllegalArgumentException(message);
                    }
                };
                final ObjectProvider springBeanProviderInvoker = new ObjectProvider(){

                    public <T> T provide(final Class<T> objectType, final AnnotationProvider annotationProvider, final ObjectLocator locator) {
                        return (T)tracker.invoke("Resolving dependency by searching Spring ApplicationContext", new Invokable<T>(){

                            public T invoke() {
                                return springBeanProvider.provide(objectType, annotationProvider, locator);
                            }
                        });
                    }
                };
                ObjectProvider outerCheck = new ObjectProvider(){

                    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                        if (!SpringModuleDef.this.applicationContextCreated.get()) {
                            return null;
                        }
                        return (T)springBeanProviderInvoker.provide(objectType, annotationProvider, locator);
                    }
                };
                configuration.add("SpringBean", (Object)outerCheck, new String[]{"after:Service,Alias,Autobuild"});
            }
        };
        return def;
    }

    public Set<DecoratorDef> getDecoratorDefs() {
        return Collections.emptySet();
    }

    public String getLoggerName() {
        return SpringModuleDef.class.getName();
    }

    public ServiceDef getServiceDef(String serviceId) {
        return this.services.get(serviceId);
    }

    public Set<String> getServiceIds() {
        return this.services.keySet();
    }
}

