/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import com.thoughtworks.selenium.CommandProcessor;
import org.apache.tapestry5.test.ErrorReporter;

public class ErrorReportingCommandProcessor
implements CommandProcessor {
    private final CommandProcessor delegate;
    private final ErrorReporter errorReporter;
    private static final String BORDER = "**********************************************************************";

    public ErrorReportingCommandProcessor(CommandProcessor delegate, ErrorReporter errorReporter) {
        this.delegate = delegate;
        this.errorReporter = errorReporter;
    }

    private void reportError(String command, String[] args, RuntimeException ex) {
        StringBuilder builder = new StringBuilder();
        builder.append("Selenium failure processing command ");
        builder.append(command);
        builder.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append('\"');
            builder.append(args[i]);
            builder.append('\"');
        }
        builder.append("): ");
        builder.append(ex.toString());
        try {
            String logs = this.delegate.getString("retrieveLastRemoteControlLogs", new String[0]);
            if (logs != null && logs.length() > 0) {
                builder.append('\n');
                builder.append(BORDER);
                builder.append('\n');
                builder.append(logs);
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        String report = builder.toString();
        System.err.println(BORDER);
        System.err.println(report);
        System.err.println(BORDER);
        this.errorReporter.writeErrorReport(report);
    }

    public String doCommand(String command, String[] args) {
        try {
            return this.delegate.doCommand(command, args);
        }
        catch (RuntimeException ex) {
            this.reportError(command, args, ex);
            throw ex;
        }
    }

    public boolean getBoolean(String string, String[] strings) {
        try {
            return this.delegate.getBoolean(string, strings);
        }
        catch (RuntimeException ex) {
            this.reportError(string, strings, ex);
            throw ex;
        }
    }

    public boolean[] getBooleanArray(String string, String[] strings) {
        try {
            return this.delegate.getBooleanArray(string, strings);
        }
        catch (RuntimeException ex) {
            this.reportError(string, strings, ex);
            throw ex;
        }
    }

    public Number getNumber(String string, String[] strings) {
        try {
            return this.delegate.getNumber(string, strings);
        }
        catch (RuntimeException ex) {
            this.reportError(string, strings, ex);
            throw ex;
        }
    }

    public Number[] getNumberArray(String string, String[] strings) {
        try {
            return this.delegate.getNumberArray(string, strings);
        }
        catch (RuntimeException ex) {
            this.reportError(string, strings, ex);
            throw ex;
        }
    }

    public String getString(String string, String[] strings) {
        try {
            return this.delegate.getString(string, strings);
        }
        catch (RuntimeException ex) {
            this.reportError(string, strings, ex);
            throw ex;
        }
    }

    public String[] getStringArray(String string, String[] strings) {
        try {
            return this.delegate.getStringArray(string, strings);
        }
        catch (RuntimeException ex) {
            this.reportError(string, strings, ex);
            throw ex;
        }
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public String getRemoteControlServerLocation() {
        return this.delegate.getRemoteControlServerLocation();
    }

    public void setExtensionJs(String extensionJs) {
        this.delegate.setExtensionJs(extensionJs);
    }

    public void start(String optionsString) {
        this.delegate.start(optionsString);
    }

    public void start(Object optionsObject) {
        this.delegate.start(optionsObject);
    }
}

