/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.internal.webresources.RhinoExecutor;
import org.apache.tapestry5.internal.webresources.RhinoExecutorPool;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.ResourceTransformer;
import org.mozilla.javascript.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeScriptCompiler
implements ResourceTransformer {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final RhinoExecutorPool executorPool;

    public String getTransformedContentType() {
        return "text/javascript";
    }

    public CoffeeScriptCompiler(@Path(value="classpath:org/apache/tapestry5/webresources/internal/coffee-script.js") Resource mainCompiler, @Path(value="classpath:org/apache/tapestry5/webresources/internal/invoke-coffeescript.js") Resource shim, OperationTracker tracker) {
        this.executorPool = new RhinoExecutorPool(tracker, this.toList(mainCompiler, shim));
    }

    private List<Resource> toList(Resource ... resources) {
        List list = CollectionFactory.newList();
        for (Resource r : resources) {
            list.add(r);
        }
        return list;
    }

    private String getString(NativeObject object, String key) {
        return object.get((Object)key).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
        String content;
        InputStream is = null;
        try {
            is = source.openStream();
            content = IOUtils.toString((InputStream)is, (Charset)UTF8);
        }
        finally {
            InternalUtils.close((Closeable)is);
        }
        RhinoExecutor executor = this.executorPool.get();
        try {
            NativeObject result = (NativeObject)executor.invokeFunction("compileCoffeeScriptSource", content, source.toString());
            if (result.containsKey((Object)"exception")) {
                throw new RuntimeException(this.getString(result, "exception"));
            }
            InputStream inputStream = IOUtils.toInputStream((String)this.getString(result, "output"), (Charset)UTF8);
            return inputStream;
        }
        finally {
            executor.discard();
        }
    }
}

