/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.ResourceTransformer;

public class LessResourceTransformer
implements ResourceTransformer {
    private final LessCompiler compiler = new DefaultLessCompiler();

    public String getTransformedContentType() {
        return "text/css";
    }

    public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
        BytestreamCache compiled = this.invokeLessCompiler(source, dependencies);
        return compiled.openStream();
    }

    private BytestreamCache invokeLessCompiler(Resource source, ResourceDependencies dependencies) throws IOException {
        try {
            ResourceLessSource lessSource = new ResourceLessSource(source, dependencies);
            LessCompiler.CompilationResult compilationResult = this.compiler.compile((LessSource)lessSource);
            return new BytestreamCache(compilationResult.getCss().getBytes("utf-8"));
        }
        catch (Less4jException ex) {
            throw new IOException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex);
        }
    }

    class ResourceLessSource
    extends LessSource {
        private final Resource resource;
        private final ResourceDependencies dependencies;

        ResourceLessSource(Resource resource, ResourceDependencies dependencies) {
            this.resource = resource;
            this.dependencies = dependencies;
        }

        public LessSource relativeSource(String filename) throws LessSource.FileNotFound, LessSource.CannotReadFile, LessSource.StringSourceException {
            Resource relative = this.resource.forFile(filename);
            if (!relative.exists()) {
                throw new LessSource.FileNotFound();
            }
            this.dependencies.addDependency(relative);
            return new ResourceLessSource(relative, this.dependencies);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
            String string;
            InputStreamReader input = null;
            try {
                String content;
                input = new InputStreamReader(this.resource.openStream());
                string = content = IOUtils.toString((Reader)input).replace("\r\n", "\n");
            }
            catch (FileNotFoundException ex) {
                try {
                    throw new LessSource.FileNotFound();
                    catch (IOException ex2) {
                        throw new LessSource.CannotReadFile();
                    }
                }
                catch (Throwable throwable) {
                    InternalUtils.close(input);
                    throw throwable;
                }
            }
            InternalUtils.close((Closeable)input);
            return string;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
            byte[] byArray;
            InputStreamReader input = null;
            try {
                input = new InputStreamReader(this.resource.openStream());
                byArray = IOUtils.toByteArray((Reader)input);
            }
            catch (FileNotFoundException ex) {
                try {
                    throw new LessSource.FileNotFound();
                    catch (IOException ex2) {
                        throw new LessSource.CannotReadFile();
                    }
                }
                catch (Throwable throwable) {
                    InternalUtils.close(input);
                    throw throwable;
                }
            }
            InternalUtils.close((Closeable)input);
            return byArray;
        }
    }
}

