/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.txprune;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.tephra.Transaction;
import org.apache.tephra.hbase.txprune.DataJanitorState;
import org.apache.tephra.hbase.txprune.PruneUpperBoundWriter;
import org.apache.tephra.hbase.txprune.PruneUpperBoundWriterSupplier;
import org.apache.tephra.persist.TransactionVisibilityState;
import org.apache.tephra.util.TxUtils;

public class CompactionState {
    private static final Log LOG = LogFactory.getLog(CompactionState.class);
    private final byte[] regionName;
    private final String regionNameAsString;
    private final PruneUpperBoundWriterSupplier pruneUpperBoundWriterSupplier;
    private final PruneUpperBoundWriter pruneUpperBoundWriter;
    private volatile long pruneUpperBound = -1L;

    public CompactionState(final RegionCoprocessorEnvironment env, final TableName stateTable, long pruneFlushInterval) {
        this.regionName = env.getRegion().getRegionName();
        this.regionNameAsString = env.getRegion().getRegionNameAsString();
        DataJanitorState dataJanitorState = new DataJanitorState(new DataJanitorState.TableSupplier(){

            @Override
            public HTableInterface get() throws IOException {
                return env.getTable(stateTable);
            }
        });
        this.pruneUpperBoundWriterSupplier = new PruneUpperBoundWriterSupplier(stateTable, dataJanitorState, pruneFlushInterval);
        this.pruneUpperBoundWriter = this.pruneUpperBoundWriterSupplier.get();
    }

    public void record(CompactionRequest request, @Nullable TransactionVisibilityState snapshot) {
        if (request.isMajor() && snapshot != null) {
            Transaction tx = TxUtils.createDummyTransaction((TransactionVisibilityState)snapshot);
            this.pruneUpperBound = TxUtils.getPruneUpperBound((Transaction)tx);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Computed prune upper bound %s for compaction request %s using transaction state from time %s", this.pruneUpperBound, request, snapshot.getTimestamp()));
            }
        } else {
            this.pruneUpperBound = -1L;
        }
    }

    public void persist() {
        if (this.pruneUpperBound != -1L) {
            this.pruneUpperBoundWriter.persistPruneEntry(this.regionName, this.pruneUpperBound);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Enqueued prune upper bound %s for region %s", this.pruneUpperBound, this.regionNameAsString));
            }
        }
    }

    public void persistRegionEmpty(long time) {
        this.pruneUpperBoundWriter.persistRegionEmpty(this.regionName, time);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Enqueued empty region %s at time %s", this.regionNameAsString, time));
        }
    }

    public void stop() {
        this.pruneUpperBoundWriterSupplier.release();
    }
}

