/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.txprune;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.hbase.txprune.TimeRegions;
import org.apache.tephra.txprune.RegionPruneInfo;

public class DataJanitorState {
    private static final Log LOG = LogFactory.getLog(DataJanitorState.class);
    public static final byte[] FAMILY = new byte[]{102};
    public static final byte[] PRUNE_UPPER_BOUND_COL = new byte[]{112};
    private static final byte[] REGION_TIME_COL = new byte[]{114};
    private static final byte[] INACTIVE_TRANSACTION_BOUND_TIME_COL = new byte[]{105};
    private static final byte[] EMPTY_REGION_TIME_COL = new byte[]{101};
    private static final byte[] REGION_KEY_PREFIX = new byte[]{1};
    private static final byte[] REGION_KEY_PREFIX_STOP = new byte[]{2};
    private static final byte[] REGION_TIME_KEY_PREFIX = new byte[]{2};
    private static final byte[] REGION_TIME_KEY_PREFIX_STOP = new byte[]{3};
    private static final byte[] INACTIVE_TRANSACTION_BOUND_TIME_KEY_PREFIX = new byte[]{3};
    private static final byte[] INACTIVE_TRANSACTION_BOUND_TIME_KEY_PREFIX_STOP = new byte[]{4};
    private static final byte[] EMPTY_REGION_TIME_KEY_PREFIX = new byte[]{4};
    private static final byte[] EMPTY_REGION_TIME_KEY_PREFIX_STOP = new byte[]{5};
    private static final byte[] REGION_TIME_COUNT_KEY_PREFIX = new byte[]{5};
    private static final byte[] REGION_TIME_COUNT_KEY_PREFIX_STOP = new byte[]{6};
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte[] COL_VAL = Bytes.toBytes((int)49);
    private final TableSupplier stateTableSupplier;

    public DataJanitorState(TableSupplier stateTableSupplier) {
        this.stateTableSupplier = stateTableSupplier;
    }

    public void savePruneUpperBoundForRegion(byte[] regionId, long pruneUpperBound) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Put put = new Put(this.makeRegionKey(regionId));
            put.add(FAMILY, PRUNE_UPPER_BOUND_COL, Bytes.toBytes((long)pruneUpperBound));
            stateTable.put(put);
        }
    }

    public long getPruneUpperBoundForRegion(byte[] regionId) throws IOException {
        RegionPruneInfo regionPruneInfo = this.getPruneInfoForRegion(regionId);
        return regionPruneInfo == null ? -1L : regionPruneInfo.getPruneUpperBound();
    }

    @Nullable
    public RegionPruneInfo getPruneInfoForRegion(byte[] regionId) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Get get = new Get(this.makeRegionKey(regionId));
            get.addColumn(FAMILY, PRUNE_UPPER_BOUND_COL);
            Cell cell = stateTable.get(get).getColumnLatestCell(FAMILY, PRUNE_UPPER_BOUND_COL);
            if (cell == null) {
                RegionPruneInfo regionPruneInfo = null;
                return regionPruneInfo;
            }
            byte[] pruneUpperBoundBytes = CellUtil.cloneValue((Cell)cell);
            long timestamp = cell.getTimestamp();
            RegionPruneInfo regionPruneInfo = new RegionPruneInfo(regionId, Bytes.toStringBinary((byte[])regionId), Bytes.toLong((byte[])pruneUpperBoundBytes), timestamp);
            return regionPruneInfo;
        }
    }

    public Map<byte[], Long> getPruneUpperBoundForRegions(SortedSet<byte[]> regions) throws IOException {
        TreeMap<byte[], Long> resultMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        List<RegionPruneInfo> regionPruneInfos = this.getPruneInfoForRegions(regions);
        for (RegionPruneInfo regionPruneInfo : regionPruneInfos) {
            resultMap.put(regionPruneInfo.getRegionName(), regionPruneInfo.getPruneUpperBound());
        }
        return Collections.unmodifiableMap(resultMap);
    }

    public List<RegionPruneInfo> getPruneInfoForRegions(@Nullable SortedSet<byte[]> regions) throws IOException {
        ArrayList<RegionPruneInfo> regionPruneInfos = new ArrayList<RegionPruneInfo>();
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            byte[] startRow = this.makeRegionKey(EMPTY_BYTE_ARRAY);
            Scan scan = new Scan(startRow, REGION_KEY_PREFIX_STOP);
            scan.addColumn(FAMILY, PRUNE_UPPER_BOUND_COL);
            try (ResultScanner scanner = stateTable.getScanner(scan);){
                Result next;
                while ((next = scanner.next()) != null) {
                    Cell cell;
                    byte[] region = this.getRegionFromKey(next.getRow());
                    if (regions != null && !regions.contains(region) || (cell = next.getColumnLatestCell(FAMILY, PRUNE_UPPER_BOUND_COL)) == null) continue;
                    byte[] pruneUpperBoundBytes = CellUtil.cloneValue((Cell)cell);
                    long timestamp = cell.getTimestamp();
                    regionPruneInfos.add(new RegionPruneInfo(region, Bytes.toStringBinary((byte[])region), Bytes.toLong((byte[])pruneUpperBoundBytes), timestamp));
                }
            }
        }
        return Collections.unmodifiableList(regionPruneInfos);
    }

    public void deletePruneUpperBounds(long deletionPruneUpperBound, SortedSet<byte[]> excludeRegions) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            byte[] startRow = this.makeRegionKey(EMPTY_BYTE_ARRAY);
            Scan scan = new Scan(startRow, REGION_KEY_PREFIX_STOP);
            scan.addColumn(FAMILY, PRUNE_UPPER_BOUND_COL);
            try (ResultScanner scanner = stateTable.getScanner(scan);){
                Result next;
                while ((next = scanner.next()) != null) {
                    long pruneUpperBoundRegion;
                    byte[] timeBytes;
                    byte[] region = this.getRegionFromKey(next.getRow());
                    if (excludeRegions.contains(region) || (timeBytes = next.getValue(FAMILY, PRUNE_UPPER_BOUND_COL)) == null || (pruneUpperBoundRegion = Bytes.toLong((byte[])timeBytes)) >= deletionPruneUpperBound) continue;
                    stateTable.delete(new Delete(next.getRow()));
                }
            }
        }
    }

    public void saveRegionsForTime(long time, Set<byte[]> regions) throws IOException {
        byte[] timeBytes = Bytes.toBytes((long)this.getInvertedTime(time));
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            for (byte[] region : regions) {
                Put put = new Put(this.makeTimeRegionKey(timeBytes, region));
                put.add(FAMILY, REGION_TIME_COL, COL_VAL);
                stateTable.put(put);
            }
            this.saveRegionCountForTime(stateTable, timeBytes, regions.size());
        }
    }

    @VisibleForTesting
    void saveRegionCountForTime(HTableInterface stateTable, byte[] timeBytes, int count) throws IOException {
        Put put = new Put(this.makeTimeRegionCountKey(timeBytes));
        put.add(FAMILY, REGION_TIME_COL, Bytes.toBytes((int)count));
        stateTable.put(put);
    }

    @Nullable
    public TimeRegions getRegionsOnOrBeforeTime(long time) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            TimeRegions timeRegions;
            while ((timeRegions = this.getNextSetOfTimeRegions(stateTable, time)) != null) {
                int count = this.getRegionCountForTime(stateTable, timeRegions.getTime());
                if (count != -1 && count == timeRegions.getRegions().size()) {
                    TimeRegions timeRegions2 = timeRegions;
                    return timeRegions2;
                }
                LOG.warn((Object)String.format("Got incorrect count for regions saved at time %s, expected = %s but actual = %s", timeRegions.getTime(), count, timeRegions.getRegions().size()));
                time = timeRegions.getTime() - 1L;
            }
            TimeRegions timeRegions3 = null;
            return timeRegions3;
        }
    }

    @Nullable
    private TimeRegions getNextSetOfTimeRegions(HTableInterface stateTable, long time) throws IOException {
        byte[] timeBytes = Bytes.toBytes((long)this.getInvertedTime(time));
        Scan scan = new Scan(this.makeTimeRegionKey(timeBytes, EMPTY_BYTE_ARRAY), REGION_TIME_KEY_PREFIX_STOP);
        scan.addColumn(FAMILY, REGION_TIME_COL);
        long currentRegionTime = -1L;
        TreeSet<byte[]> regions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        try (ResultScanner scanner = stateTable.getScanner(scan);){
            Result next;
            while ((next = scanner.next()) != null) {
                Map.Entry<Long, byte[]> timeRegion = this.getTimeRegion(next.getRow());
                if (currentRegionTime == -1L) {
                    currentRegionTime = timeRegion.getKey();
                } else {
                    if (timeRegion.getKey() < currentRegionTime) {
                        break;
                    }
                    if (timeRegion.getKey() > currentRegionTime) {
                        throw new IllegalStateException(String.format("Got out of order time %d when expecting time less than or equal to %d", timeRegion.getKey(), currentRegionTime));
                    }
                }
                regions.add(timeRegion.getValue());
            }
        }
        return regions.isEmpty() ? null : new TimeRegions(currentRegionTime, Collections.unmodifiableSortedSet(regions));
    }

    @VisibleForTesting
    int getRegionCountForTime(HTableInterface stateTable, long time) throws IOException {
        Get get = new Get(this.makeTimeRegionCountKey(Bytes.toBytes((long)this.getInvertedTime(time))));
        get.addColumn(FAMILY, REGION_TIME_COL);
        Result result = stateTable.get(get);
        byte[] value = result.getValue(FAMILY, REGION_TIME_COL);
        return value == null ? -1 : Bytes.toInt((byte[])value);
    }

    public void deleteAllRegionsOnOrBeforeTime(long time) throws IOException {
        byte[] timeBytes = Bytes.toBytes((long)this.getInvertedTime(time));
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Scan scan = new Scan(this.makeTimeRegionKey(timeBytes, EMPTY_BYTE_ARRAY), REGION_TIME_KEY_PREFIX_STOP);
            scan.addColumn(FAMILY, REGION_TIME_COL);
            this.deleteFromScan(stateTable, scan);
            scan = new Scan(this.makeTimeRegionCountKey(timeBytes), REGION_TIME_COUNT_KEY_PREFIX_STOP);
            scan.addColumn(FAMILY, REGION_TIME_COL);
            this.deleteFromScan(stateTable, scan);
        }
    }

    public void saveInactiveTransactionBoundForTime(long time, long inactiveTransactionBound) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Put put = new Put(this.makeInactiveTransactionBoundTimeKey(Bytes.toBytes((long)this.getInvertedTime(time))));
            put.add(FAMILY, INACTIVE_TRANSACTION_BOUND_TIME_COL, Bytes.toBytes((long)inactiveTransactionBound));
            stateTable.put(put);
        }
    }

    public long getInactiveTransactionBoundForTime(long time) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Get get = new Get(this.makeInactiveTransactionBoundTimeKey(Bytes.toBytes((long)this.getInvertedTime(time))));
            get.addColumn(FAMILY, INACTIVE_TRANSACTION_BOUND_TIME_COL);
            byte[] result = stateTable.get(get).getValue(FAMILY, INACTIVE_TRANSACTION_BOUND_TIME_COL);
            long l = result == null ? -1L : Bytes.toLong((byte[])result);
            return l;
        }
    }

    public void deleteInactiveTransactionBoundsOnOrBeforeTime(long time) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Scan scan = new Scan(this.makeInactiveTransactionBoundTimeKey(Bytes.toBytes((long)this.getInvertedTime(time))), INACTIVE_TRANSACTION_BOUND_TIME_KEY_PREFIX_STOP);
            scan.addColumn(FAMILY, INACTIVE_TRANSACTION_BOUND_TIME_COL);
            this.deleteFromScan(stateTable, scan);
        }
    }

    public void saveEmptyRegionForTime(long time, byte[] regionId) throws IOException {
        byte[] timeBytes = Bytes.toBytes((long)time);
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Put put = new Put(this.makeEmptyRegionTimeKey(timeBytes, regionId));
            put.add(FAMILY, EMPTY_REGION_TIME_COL, COL_VAL);
            stateTable.put(put);
        }
    }

    public SortedSet<byte[]> getEmptyRegionsAfterTime(long time, @Nullable SortedSet<byte[]> includeRegions) throws IOException {
        TreeSet<byte[]> emptyRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Scan scan = new Scan(this.makeEmptyRegionTimeKey(Bytes.toBytes((long)(time + 1L)), EMPTY_BYTE_ARRAY), EMPTY_REGION_TIME_KEY_PREFIX_STOP);
            scan.addColumn(FAMILY, EMPTY_REGION_TIME_COL);
            try (ResultScanner scanner = stateTable.getScanner(scan);){
                Result next;
                while ((next = scanner.next()) != null) {
                    byte[] emptyRegion = this.getEmptyRegionFromKey(next.getRow());
                    if (includeRegions != null && !includeRegions.contains(emptyRegion)) continue;
                    emptyRegions.add(emptyRegion);
                }
            }
        }
        return Collections.unmodifiableSortedSet(emptyRegions);
    }

    public void deleteEmptyRegionsOnOrBeforeTime(long time) throws IOException {
        try (HTableInterface stateTable = this.stateTableSupplier.get();){
            Scan scan = new Scan();
            scan.setStopRow(this.makeEmptyRegionTimeKey(Bytes.toBytes((long)(time + 1L)), EMPTY_BYTE_ARRAY));
            scan.addColumn(FAMILY, EMPTY_REGION_TIME_COL);
            this.deleteFromScan(stateTable, scan);
        }
    }

    @VisibleForTesting
    void deleteFromScan(HTableInterface stateTable, Scan scan) throws IOException {
        try (ResultScanner scanner = stateTable.getScanner(scan);){
            Result next;
            while ((next = scanner.next()) != null) {
                stateTable.delete(new Delete(next.getRow()));
            }
        }
    }

    private byte[] makeRegionKey(byte[] regionId) {
        return Bytes.add((byte[])REGION_KEY_PREFIX, (byte[])regionId);
    }

    private byte[] getRegionFromKey(byte[] regionKey) {
        int prefixLen = REGION_KEY_PREFIX.length;
        return Bytes.copy((byte[])regionKey, (int)prefixLen, (int)(regionKey.length - prefixLen));
    }

    private byte[] makeTimeRegionKey(byte[] time, byte[] regionId) {
        return Bytes.add((byte[])REGION_TIME_KEY_PREFIX, (byte[])time, (byte[])regionId);
    }

    private byte[] makeTimeRegionCountKey(byte[] time) {
        return Bytes.add((byte[])REGION_TIME_COUNT_KEY_PREFIX, (byte[])time);
    }

    private byte[] makeInactiveTransactionBoundTimeKey(byte[] time) {
        return Bytes.add((byte[])INACTIVE_TRANSACTION_BOUND_TIME_KEY_PREFIX, (byte[])time);
    }

    private Map.Entry<Long, byte[]> getTimeRegion(byte[] key) {
        int offset = REGION_TIME_KEY_PREFIX.length;
        long time = this.getInvertedTime(Bytes.toLong((byte[])key, (int)offset));
        byte[] regionName = Bytes.copy((byte[])key, (int)(offset += 8), (int)(key.length - offset));
        return Maps.immutableEntry((Object)time, (Object)regionName);
    }

    private byte[] makeEmptyRegionTimeKey(byte[] time, byte[] regionId) {
        return Bytes.add((byte[])EMPTY_REGION_TIME_KEY_PREFIX, (byte[])time, (byte[])regionId);
    }

    private byte[] getEmptyRegionFromKey(byte[] key) {
        int prefixLen = EMPTY_REGION_TIME_KEY_PREFIX.length + 8;
        return Bytes.copy((byte[])key, (int)prefixLen, (int)(key.length - prefixLen));
    }

    private long getInvertedTime(long time) {
        return Long.MAX_VALUE - time;
    }

    public static interface TableSupplier {
        public HTableInterface get() throws IOException;
    }
}

