/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.txprune;

import com.google.common.collect.Iterables;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.hbase.txprune.DataJanitorState;
import org.apache.tephra.hbase.txprune.TimeRegions;
import org.apache.tephra.txprune.RegionPruneInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidListPruningDebug {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidListPruningDebug.class);
    private static final Gson GSON = new Gson();
    private DataJanitorState dataJanitorState;
    private HConnection connection;
    private TableName tableName;

    public void initialize(Configuration conf) throws IOException {
        LOG.debug("InvalidListPruningDebugMain : initialize method called");
        this.connection = new HBaseAdmin(conf).getConnection();
        this.tableName = TableName.valueOf((String)conf.get("data.tx.prune.state.table", "tephra.state"));
        this.dataJanitorState = new DataJanitorState(new DataJanitorState.TableSupplier(){

            @Override
            public HTableInterface get() throws IOException {
                return InvalidListPruningDebug.this.connection.getTable(InvalidListPruningDebug.this.tableName);
            }
        });
    }

    public void destroy() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Set<String> getRegionsToBeCompacted(Integer numRegions) throws IOException {
        Map<Long, SortedSet<String>> latestTimeRegion = this.getRegionsOnOrBeforeTime(System.currentTimeMillis());
        if (latestTimeRegion.isEmpty()) {
            return new HashSet<String>();
        }
        Long timestamp = latestTimeRegion.keySet().iterator().next();
        SortedSet<String> liveRegions = latestTimeRegion.get(timestamp);
        SortedSet<byte[]> emptyRegions = this.dataJanitorState.getEmptyRegionsAfterTime(timestamp, null);
        TreeSet<String> emptyRegionNames = new TreeSet<String>();
        Iterable regionStrings = Iterables.transform(emptyRegions, TimeRegions.BYTE_ARR_TO_STRING_FN);
        for (String regionString : regionStrings) {
            emptyRegionNames.add(regionString);
        }
        HashSet nonEmptyRegions = Sets.newHashSet((Iterable)Sets.difference(liveRegions, emptyRegionNames));
        Queue<RegionPruneInfo> prunedRegions = this.getIdleRegions(-1);
        for (RegionPruneInfo prunedRegion : prunedRegions) {
            if (!nonEmptyRegions.contains(prunedRegion.getRegionNameAsString())) continue;
            nonEmptyRegions.remove(prunedRegion.getRegionNameAsString());
        }
        if (numRegions < 0 || numRegions >= nonEmptyRegions.size()) {
            return nonEmptyRegions;
        }
        HashSet<String> subsetRegions = new HashSet<String>(numRegions);
        for (String regionName : nonEmptyRegions) {
            if (subsetRegions.size() == numRegions.intValue()) break;
            subsetRegions.add(regionName);
        }
        return subsetRegions;
    }

    public Queue<RegionPruneInfo> getIdleRegions(Integer numRegions) throws IOException {
        List<RegionPruneInfo> regionPruneInfos = this.dataJanitorState.getPruneInfoForRegions(null);
        if (regionPruneInfos.isEmpty()) {
            return new LinkedList<RegionPruneInfo>();
        }
        HashSet<String> pruneRegionNameSet = new HashSet<String>();
        for (RegionPruneInfo regionPruneInfo : regionPruneInfos) {
            pruneRegionNameSet.add(regionPruneInfo.getRegionNameAsString());
        }
        Map<Long, SortedSet<String>> latestTimeRegion = this.getRegionsOnOrBeforeTime(System.currentTimeMillis());
        if (!latestTimeRegion.isEmpty()) {
            SortedSet<String> liveRegions = latestTimeRegion.values().iterator().next();
            Sets.SetView liveRegionsWithPruneInfo = Sets.intersection(liveRegions, pruneRegionNameSet);
            ArrayList<RegionPruneInfo> liveRegionWithPruneInfoList = new ArrayList<RegionPruneInfo>();
            for (RegionPruneInfo regionPruneInfo : regionPruneInfos) {
                if (!liveRegionsWithPruneInfo.contains(regionPruneInfo.getRegionNameAsString())) continue;
                liveRegionWithPruneInfoList.add(regionPruneInfo);
            }
            regionPruneInfos = liveRegionWithPruneInfoList;
        }
        if (numRegions < 0) {
            numRegions = regionPruneInfos.size();
        }
        MinMaxPriorityQueue lowestPrunes = MinMaxPriorityQueue.orderedBy((Comparator)new Comparator<RegionPruneInfo>(){

            @Override
            public int compare(RegionPruneInfo o1, RegionPruneInfo o2) {
                return (int)(o1.getPruneUpperBound() - o2.getPruneUpperBound());
            }
        }).maximumSize(numRegions.intValue()).create();
        for (RegionPruneInfo pruneInfo : regionPruneInfos) {
            lowestPrunes.add(pruneInfo);
        }
        return lowestPrunes;
    }

    @Nullable
    public RegionPruneInfo getRegionPruneInfo(String regionId) throws IOException {
        return this.dataJanitorState.getPruneInfoForRegion(Bytes.toBytesBinary((String)regionId));
    }

    public Map<Long, SortedSet<String>> getRegionsOnOrBeforeTime(Long time) throws IOException {
        HashMap<Long, SortedSet<String>> regionMap = new HashMap<Long, SortedSet<String>>();
        TimeRegions timeRegions = this.dataJanitorState.getRegionsOnOrBeforeTime(time);
        if (timeRegions == null) {
            return regionMap;
        }
        TreeSet<String> regionNames = new TreeSet<String>();
        Iterable regionStrings = Iterables.transform(timeRegions.getRegions(), TimeRegions.BYTE_ARR_TO_STRING_FN);
        for (String regionString : regionStrings) {
            regionNames.add(regionString);
        }
        regionMap.put(timeRegions.getTime(), regionNames);
        return regionMap;
    }

    private void printUsage(PrintWriter pw) {
        pw.println("Usage : org.apache.tephra.hbase.txprune.InvalidListPruning <command> <parameter>");
        pw.println("Available commands, corresponding parameters are:");
        pw.println("****************************************************");
        pw.println("time-region ts");
        pw.println("Desc: Prints out the transactional regions present in HBase at time 'ts' (in milliseconds) or the latest time before time 'ts'.");
        pw.println("idle-regions limit");
        pw.println("Desc: Prints out 'limit' number of regions which has the lowest prune upper bounds. If '-1' is provided as the limit, prune upper bounds of all regions are returned.");
        pw.println("prune-info region-name-as-string");
        pw.println("Desc: Prints out the Pruning information for the region 'region-name-as-string'");
        pw.println("to-compact-regions limit");
        pw.println("Desc: Prints out 'limit' number of regions that are active, but are not empty, and have not registered a prune upper bound.");
    }

    private boolean execute(String[] args) throws IOException {
        try (PrintWriter pw = new PrintWriter(System.out);){
            if (args.length != 2) {
                this.printUsage(pw);
                boolean bl = false;
                return bl;
            }
            String command = args[0];
            String parameter = args[1];
            if ("time-region".equals(command)) {
                Long time = Long.parseLong(parameter);
                Map<Long, SortedSet<String>> timeRegion = this.getRegionsOnOrBeforeTime(time);
                pw.println(GSON.toJson(timeRegion));
                boolean bl = true;
                return bl;
            }
            if ("idle-regions".equals(command)) {
                Integer numRegions = Integer.parseInt(parameter);
                Queue<RegionPruneInfo> regionPruneInfos = this.getIdleRegions(numRegions);
                pw.println(GSON.toJson(regionPruneInfos));
                boolean bl = true;
                return bl;
            }
            if ("prune-info".equals(command)) {
                RegionPruneInfo regionPruneInfo = this.getRegionPruneInfo(parameter);
                if (regionPruneInfo != null) {
                    pw.println(GSON.toJson((Object)regionPruneInfo));
                } else {
                    pw.println(String.format("No prune info found for the region %s.", parameter));
                }
                boolean regionPruneInfos = true;
                return regionPruneInfos;
            }
            if ("to-compact-regions".equals(command)) {
                Integer numRegions = Integer.parseInt(parameter);
                Set<String> toBeCompactedRegions = this.getRegionsToBeCompacted(numRegions);
                pw.println(GSON.toJson(toBeCompactedRegions));
                boolean bl = true;
                return bl;
            }
            pw.println(String.format("%s is not a valid command.", command));
            this.printUsage(pw);
            boolean bl = false;
            return bl;
        }
    }

    public static void main(String[] args) {
        Configuration hConf = HBaseConfiguration.create();
        InvalidListPruningDebug pruningDebug = new InvalidListPruningDebug();
        try {
            pruningDebug.initialize(hConf);
            boolean success = pruningDebug.execute(args);
            pruningDebug.destroy();
            if (!success) {
                System.exit(1);
            }
        }
        catch (IOException ex) {
            LOG.error("Received an exception while trying to execute the debug tool. ", (Throwable)ex);
        }
    }
}

