/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.collect.Maps;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezYarnClient;
import org.apache.tez.common.counters.LimitExceededException;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.SessionNotReady;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTezClient {
    static final long HARD_KILL_TIMEOUT = 1500L;
    private static final File STAGING_DIR = new File(System.getProperty("test.build.data"), TestTezClient.class.getName()).getAbsoluteFile();

    TezClientForTest configureAndCreateTezClient() throws YarnException, IOException, ServiceException {
        return this.configureAndCreateTezClient(null);
    }

    TezClientForTest configureAndCreateTezClient(TezConfiguration conf) throws YarnException, ServiceException, IOException {
        return this.configureAndCreateTezClient(new HashMap<String, LocalResource>(), true, conf);
    }

    TezClientForTest configureAndCreateTezClient(Map<String, LocalResource> lrs, boolean isSession, TezConfiguration conf) throws YarnException, IOException, ServiceException {
        if (conf == null) {
            conf = new TezConfiguration();
        }
        conf.setBoolean("tez.ignore.lib.uris", true);
        conf.setBoolean("tez.am.mode.session", isSession);
        conf.set("tez.staging-dir", STAGING_DIR.getAbsolutePath());
        TezClientForTest client = new TezClientForTest("test", conf, lrs, null);
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)1);
        YarnClient yarnClient = (YarnClient)Mockito.mock(YarnClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)yarnClient.createApplication().getNewApplicationResponse().getApplicationId()).thenReturn((Object)appId1);
        Mockito.when((Object)yarnClient.getApplicationReport(appId1).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW);
        Mockito.when((Object)yarnClient.submitApplication((ApplicationSubmissionContext)Mockito.any())).thenReturn((Object)appId1);
        DAGClientAMProtocolBlockingPB sessionAmProxy = (DAGClientAMProtocolBlockingPB)Mockito.mock(DAGClientAMProtocolBlockingPB.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.RUNNING).build()).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.RUNNING).build());
        client.sessionAmProxy = sessionAmProxy;
        client.frameworkClient = new TezYarnClientForTest(yarnClient, client);
        client.mockYarnClient = yarnClient;
        client.mockAppId = appId1;
        return client;
    }

    @Test(timeout=5000L)
    public void testTezClientApp() throws Exception {
        this.testTezClient(false, true, "testTezClientApp");
    }

    @Test(timeout=5000L)
    public void testTezClientSession() throws Exception {
        this.testTezClient(true, true, "testTezClientSession");
    }

    @Test(timeout=5000L)
    public void testTezClientSessionLargeDAGPlan() throws Exception {
        this._testTezClientSessionLargeDAGPlan(0xA00000, 10, 10, false);
        this._testTezClientSessionLargeDAGPlan(0xA00000, 0x600000, 10, true);
        this._testTezClientSessionLargeDAGPlan(0xA00000, 0xF00000, 10, true);
        this._testTezClientSessionLargeDAGPlan(0xA00000, 10, 0x600000, true);
        this._testTezClientSessionLargeDAGPlan(0xA00000, 10, 0xF00000, true);
        this._testTezClientSessionLargeDAGPlan(0xA00000, 0x300000, 0x300000, true);
        this._testTezClientSessionLargeDAGPlan(0xA00000, 0xF00000, 0xF00000, true);
    }

    private void _testTezClientSessionLargeDAGPlan(int maxIPCMsgSize, int payloadSize, int amResourceSize, boolean shouldSerialize) throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("ipc.maximum.data.length", maxIPCMsgSize);
        conf.set("tez.staging-dir", "target/" + this.getClass().getName());
        TezClientForTest client = this.configureAndCreateTezClient(null, true, conf);
        HashMap<String, LocalResource> localResourceMap = new HashMap<String, LocalResource>();
        byte[] bytes = new byte[amResourceSize];
        Arrays.fill(bytes, (byte)1);
        String lrName = new String(bytes);
        localResourceMap.put(lrName, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        ProcessorDescriptor processorDescriptor = ProcessorDescriptor.create((String)"P");
        processorDescriptor.setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.allocate(payloadSize)));
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)processorDescriptor, (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG-testTezClientSessionLargeDAGPlan").addVertex(vertex);
        client.start();
        client.addAppMasterLocalFiles(localResourceMap);
        client.submitDAG(dag);
        client.stop();
        ArgumentCaptor captor = ArgumentCaptor.forClass(DAGClientAMProtocolRPC.SubmitDAGRequestProto.class);
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy)).submitDAG((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor.capture());
        DAGClientAMProtocolRPC.SubmitDAGRequestProto request = (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor.getValue();
        if (shouldSerialize) {
            Path dagPlanPath = new Path(request.getSerializedRequestPath());
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            fs.deleteOnExit(dagPlanPath);
            fs.delete(dagPlanPath, false);
            Assert.assertTrue((boolean)request.hasSerializedRequestPath());
            Assert.assertFalse((boolean)request.hasDAGPlan());
            Assert.assertFalse((boolean)request.hasAdditionalAmResources());
        } else {
            Assert.assertFalse((boolean)request.hasSerializedRequestPath());
            Assert.assertTrue((boolean)request.hasDAGPlan());
            Assert.assertTrue((boolean)request.hasAdditionalAmResources());
        }
    }

    @Test(timeout=5000L)
    public void testGetClient() throws Exception {
        TezClientForTest client = this.testTezClient(true, false, "testGetClient");
        ArgumentCaptor captor = ArgumentCaptor.forClass(ApplicationSubmissionContext.class);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        ApplicationId existingAppId = client.mockAppId;
        TezClientForTest client2 = this.configureAndCreateTezClient(null, true, client.amConfig.getTezConfiguration());
        String mockLR1Name = "LR1";
        Map<String, LocalResource> lrDAG = Collections.singletonMap(mockLR1Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG-testGetClient").addVertex(vertex).addTaskLocalFiles(lrDAG);
        DAGClient dagClient = client2.getClient(existingAppId).submitDAG(dag);
        Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(existingAppId.toString()));
        Assert.assertEquals((Object)dagClient.getSessionIdentifierString(), (Object)existingAppId.toString());
        ((YarnClient)Mockito.verify((Object)client2.mockYarnClient, (VerificationMode)Mockito.times((int)0))).submitApplication((ApplicationSubmissionContext)captor.capture());
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client2.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).submitDAG((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)Mockito.any());
        client2.stop();
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client2.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).shutdownSession((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.ShutdownSessionRequestProto)Mockito.any());
        ((YarnClient)Mockito.verify((Object)client2.mockYarnClient, (VerificationMode)Mockito.times((int)1))).stop();
    }

    public TezClientForTest testTezClient(boolean isSession, boolean shouldStop, String dagName) throws Exception {
        HashMap lrs = Maps.newHashMap();
        String lrName1 = "LR1";
        lrs.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        TezClientForTest client = this.configureAndCreateTezClient(lrs, isSession, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ApplicationSubmissionContext.class);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        client.start();
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).init((Configuration)Mockito.any());
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).start();
        if (isSession) {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)captor.getValue();
            Assert.assertEquals((long)3L, (long)context.getAMContainerSpec().getLocalResources().size());
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez.session.local-resources.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-conf.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName1));
        } else {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)0))).submitApplication((ApplicationSubmissionContext)captor.capture());
        }
        String mockLR1Name = "LR1";
        Map<String, LocalResource> lrDAG = Collections.singletonMap(mockLR1Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)("DAG-" + dagName)).addVertex(vertex).addTaskLocalFiles(lrDAG);
        if (!isSession) {
            Mockito.when((Object)client.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.SHUTDOWN).build());
        }
        DAGClient dagClient = client.submitDAG(dag);
        Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(client.mockAppId.toString()));
        Assert.assertEquals((Object)dagClient.getSessionIdentifierString(), (Object)client.mockAppId.toString());
        if (isSession) {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).submitDAG((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)Mockito.any());
        } else {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)captor.getValue();
            Assert.assertEquals((long)4L, (long)context.getAMContainerSpec().getLocalResources().size());
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez.session.local-resources.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-conf.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-dag.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName1));
        }
        String lrName2 = "LR2";
        lrs.clear();
        lrs.put(lrName2, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test2"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        client.addAppMasterLocalFiles(lrs);
        ApplicationId appId2 = ApplicationId.newInstance((long)0L, (int)2);
        Mockito.when((Object)client.mockYarnClient.createApplication().getNewApplicationResponse().getApplicationId()).thenReturn((Object)appId2);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(appId2).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        dag = DAG.create((String)("DAG-2-" + dagName)).addVertex(Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1)));
        dagClient = client.submitDAG(dag);
        if (isSession) {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(client.mockAppId.toString()));
            Assert.assertEquals((Object)dagClient.getSessionIdentifierString(), (Object)client.mockAppId.toString());
            ArgumentCaptor captor1 = ArgumentCaptor.forClass(DAGClientAMProtocolRPC.SubmitDAGRequestProto.class);
            ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)2))).submitDAG((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.capture());
            DAGClientAMProtocolRPC.SubmitDAGRequestProto proto = (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.getValue();
            Assert.assertEquals((long)1L, (long)proto.getAdditionalAmResources().getLocalResourcesCount());
            Assert.assertEquals((Object)lrName2, (Object)proto.getAdditionalAmResources().getLocalResources(0).getName());
        } else {
            Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(appId2.toString()));
            Assert.assertEquals((Object)dagClient.getSessionIdentifierString(), (Object)appId2.toString());
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)2))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)captor.getValue();
            Assert.assertEquals((long)5L, (long)context.getAMContainerSpec().getLocalResources().size());
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez.session.local-resources.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-conf.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-dag.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName1));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName2));
        }
        if (shouldStop) {
            client.stop();
            if (isSession) {
                ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).shutdownSession((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.ShutdownSessionRequestProto)Mockito.any());
            }
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).stop();
        }
        return client;
    }

    @Test(timeout=5000L)
    public void testPreWarm() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient();
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        Mockito.when((Object)client.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.READY).build());
        PreWarmVertex vertex = PreWarmVertex.create((String)"PreWarm", (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        client.preWarm(vertex);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(DAGClientAMProtocolRPC.SubmitDAGRequestProto.class);
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).submitDAG((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.capture());
        DAGClientAMProtocolRPC.SubmitDAGRequestProto proto = (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.getValue();
        Assert.assertTrue((boolean)proto.getDAGPlan().getName().startsWith("TezPreWarmDAG"));
        this.setClientToReportStoppedDags(client);
        client.stop();
    }

    @Test(timeout=5000L)
    public void testPreWarmCloseStuck() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient();
        client.setPrewarmTimeoutMs(10L);
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        Mockito.when((Object)client.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.READY).build());
        PreWarmVertex vertex = PreWarmVertex.create((String)"PreWarm", (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        client.preWarm(vertex);
        client.stop();
    }

    private void setClientToReportStoppedDags(TezClientForTest client) throws Exception {
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FINISHED);
        Mockito.when((Object)client.sessionAmProxy.getDAGStatus((RpcController)Mockito.isNull(), (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(DAGProtos.DAGStatusProto.newBuilder().addDiagnostics("Diagnostics_0").setState(DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED).setDAGProgress(DAGProtos.ProgressProto.newBuilder().setFailedTaskCount(0).setKilledTaskCount(0).setRunningTaskCount(0).setSucceededTaskCount(1).setTotalTaskCount(1).build()).build()).build());
    }

    @Test(timeout=30000L)
    public void testPreWarmWithTimeout() throws Exception {
        long startTime = 0L;
        long endTime = 0L;
        TezClientForTest client = this.configureAndCreateTezClient();
        final TezClientForTest spyClient = (TezClientForTest)((Object)Mockito.spy((Object)((Object)client)));
        ((TezClientForTest)((Object)Mockito.doCallRealMethod().when((Object)spyClient))).start();
        ((TezClientForTest)((Object)Mockito.doCallRealMethod().when((Object)spyClient))).stop();
        spyClient.start();
        Mockito.when((Object)spyClient.mockYarnClient.getApplicationReport(spyClient.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        Mockito.when((Object)spyClient.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.INITIALIZING).build());
        PreWarmVertex vertex = PreWarmVertex.create((String)"PreWarm", (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        int timeout = 5000;
        try {
            startTime = Time.monotonicNow();
            spyClient.preWarm(vertex, timeout, TimeUnit.MILLISECONDS);
            Assert.fail((String)"PreWarm should have encountered an Exception!");
        }
        catch (SessionNotReady te) {
            endTime = Time.monotonicNow();
            Assert.assertTrue((String)"Time taken is not as expected", (endTime - startTime > (long)timeout ? 1 : 0) != 0);
            ((TezClientForTest)((Object)Mockito.verify((Object)((Object)spyClient), (VerificationMode)Mockito.times((int)0)))).submitDAG((DAG)Mockito.any());
            Assert.assertTrue((String)("Unexpected Exception message: " + te.getMessage()), (boolean)te.getMessage().contains("Tez AM not ready"));
        }
        Mockito.when((Object)spyClient.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.READY).build());
        try {
            startTime = Time.monotonicNow();
            spyClient.preWarm(vertex, timeout, TimeUnit.MILLISECONDS);
            endTime = Time.monotonicNow();
            Assert.assertTrue((String)"Time taken is not as expected", (endTime - startTime <= (long)timeout ? 1 : 0) != 0);
            ((TezClientForTest)((Object)Mockito.verify((Object)((Object)spyClient), (VerificationMode)Mockito.times((int)1)))).submitDAG((DAG)Mockito.any());
        }
        catch (TezException te) {
            Assert.fail((String)"PreWarm should have succeeded!");
        }
        Thread amStateThread = new Thread(){

            @Override
            public void run() {
                CountDownLatch latch = new CountDownLatch(1);
                try {
                    Mockito.when((Object)spyClient.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.INITIALIZING).build());
                    latch.await(1000L, TimeUnit.MILLISECONDS);
                    Mockito.when((Object)spyClient.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezAppMasterStatusProto.READY).build());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        };
        amStateThread.start();
        startTime = Time.monotonicNow();
        spyClient.preWarm(vertex, timeout, TimeUnit.MILLISECONDS);
        endTime = Time.monotonicNow();
        Assert.assertTrue((String)"Time taken is not as expected", (endTime - startTime <= (long)timeout ? 1 : 0) != 0);
        ((TezClientForTest)((Object)Mockito.verify((Object)((Object)spyClient), (VerificationMode)Mockito.times((int)2)))).submitDAG((DAG)Mockito.any());
        this.setClientToReportStoppedDags(client);
        spyClient.stop();
        client.stop();
    }

    @Test(timeout=10000L)
    public void testMultipleSubmissions() throws Exception {
        this.testMultipleSubmissionsJob(false);
        this.testMultipleSubmissionsJob(true);
    }

    public void testMultipleSubmissionsJob(boolean isSession) throws Exception {
        TezClientForTest client1 = this.configureAndCreateTezClient(new HashMap<String, LocalResource>(), isSession, null);
        Mockito.when((Object)client1.mockYarnClient.getApplicationReport(client1.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        client1.start();
        String mockLR1Name = "LR1";
        Map<String, LocalResource> lrDAG = Collections.singletonMap(mockLR1Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        String mockLR2Name = "LR2";
        Map<String, LocalResource> lrVertex = Collections.singletonMap(mockLR2Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1)).addTaskLocalFiles(lrVertex);
        DAG dag = DAG.create((String)("DAG-testMultipleSubmissionsJob-session-" + isSession)).addVertex(vertex).addTaskLocalFiles(lrDAG);
        client1.submitDAG(dag);
        TezClientForTest client2 = this.configureAndCreateTezClient();
        Mockito.when((Object)client2.mockYarnClient.getApplicationReport(client2.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        client2.start();
        client2.submitDAG(dag);
        client1.stop();
        client2.stop();
    }

    @Test(timeout=5000L)
    public void testWaitTillReady_Interrupt() throws Exception {
        final TezClientForTest client = this.configureAndCreateTezClient();
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW);
        final AtomicReference exceptionReference = new AtomicReference();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    client.waitTillReady();
                }
                catch (Exception e) {
                    exceptionReference.set(e);
                }
            }
        };
        thread.start();
        thread.join(250L);
        thread.interrupt();
        thread.join();
        Assert.assertThat(exceptionReference.get(), (Matcher)CoreMatchers.instanceOf(InterruptedException.class));
        client.stop();
    }

    @Test(timeout=5000L)
    public void testWaitTillReadyAppFailed() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient();
        client.start();
        String msg = "Application Test Failed";
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW).thenReturn((Object)YarnApplicationState.FAILED);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getDiagnostics()).thenReturn((Object)msg);
        try {
            client.waitTillReady();
            Assert.fail();
        }
        catch (SessionNotRunning e) {
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
        client.stop();
    }

    @Test(timeout=5000L)
    public void testWaitTillReadyAppFailedNoDiagnostics() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient();
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW).thenReturn((Object)YarnApplicationState.FAILED);
        try {
            client.waitTillReady();
            Assert.fail();
        }
        catch (SessionNotRunning e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No cluster diagnostics found."));
        }
        client.stop();
    }

    @Test(timeout=5000L)
    public void testSubmitDAGAppFailed() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient();
        client.start();
        client.callRealGetSessionAMProxy = true;
        String msg = "Application Test Failed";
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.KILLED);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getDiagnostics()).thenReturn((Object)msg);
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG-testSubmitDAGAppFailed").addVertex(vertex);
        try {
            client.submitDAG(dag);
            Assert.fail();
        }
        catch (SessionNotRunning e) {
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
        client.stop();
    }

    @Test(timeout=5000L)
    public void testTezClientCounterLimits() throws YarnException, IOException, ServiceException {
        Limits.reset();
        int defaultCounterLimit = 1200;
        int newCounterLimit = defaultCounterLimit + 500;
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.counters.max", newCounterLimit);
        this.configureAndCreateTezClient(conf);
        TezCounters counters = new TezCounters();
        for (int i = 0; i < newCounterLimit; ++i) {
            counters.findCounter("GroupName", "TestCounter" + i).setValue((long)i);
        }
        try {
            counters.findCounter("GroupName", "TestCounterFail").setValue(1L);
            Assert.fail((String)"Expecting a LimitExceedException - too many counters");
        }
        catch (LimitExceededException limitExceededException) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testClientBuilder() {
        TezConfiguration tezConfWitSession = new TezConfiguration();
        tezConfWitSession.setBoolean("tez.am.mode.session", true);
        TezConfiguration tezConfNoSession = new TezConfiguration();
        tezConfNoSession.setBoolean("tez.am.mode.session", false);
        Credentials credentials = new Credentials();
        HashMap<String, Object> localResourceMap = new HashMap<String, Object>();
        localResourceMap.put("testResource", Mockito.mock(LocalResource.class));
        ServicePluginsDescriptor servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)true);
        TezClient tezClient = TezClient.newBuilder((String)"client", (TezConfiguration)tezConfWitSession).build();
        Assert.assertTrue((boolean)tezClient.isSession);
        Assert.assertNull((Object)tezClient.servicePluginsDescriptor);
        Assert.assertNotNull((Object)tezClient.apiVersionInfo);
        AMConfiguration amConf = tezClient.amConfig;
        Assert.assertNotNull((Object)amConf);
        Assert.assertEquals((long)0L, (long)amConf.getAMLocalResources().size());
        Assert.assertNull((Object)amConf.getCredentials());
        Assert.assertTrue((boolean)amConf.getTezConfiguration().getBoolean("tez.am.mode.session", false));
        tezClient = TezClient.newBuilder((String)"client", (TezConfiguration)tezConfNoSession).build();
        Assert.assertFalse((boolean)tezClient.isSession);
        Assert.assertNull((Object)tezClient.servicePluginsDescriptor);
        Assert.assertNotNull((Object)tezClient.apiVersionInfo);
        amConf = tezClient.amConfig;
        Assert.assertNotNull((Object)amConf);
        Assert.assertEquals((long)0L, (long)amConf.getAMLocalResources().size());
        Assert.assertNull((Object)amConf.getCredentials());
        Assert.assertFalse((boolean)amConf.getTezConfiguration().getBoolean("tez.am.mode.session", true));
        tezClient = TezClient.newBuilder((String)"client", (TezConfiguration)tezConfNoSession).setIsSession(true).build();
        Assert.assertTrue((boolean)tezClient.isSession);
        Assert.assertNull((Object)tezClient.servicePluginsDescriptor);
        Assert.assertNotNull((Object)tezClient.apiVersionInfo);
        amConf = tezClient.amConfig;
        Assert.assertNotNull((Object)amConf);
        Assert.assertEquals((long)0L, (long)amConf.getAMLocalResources().size());
        Assert.assertNull((Object)amConf.getCredentials());
        Assert.assertTrue((boolean)amConf.getTezConfiguration().getBoolean("tez.am.mode.session", false));
        tezClient = TezClient.newBuilder((String)"client", (TezConfiguration)tezConfWitSession).setCredentials(credentials).setLocalResources(localResourceMap).setServicePluginDescriptor(servicePluginsDescriptor).build();
        Assert.assertTrue((boolean)tezClient.isSession);
        Assert.assertEquals((Object)servicePluginsDescriptor, (Object)tezClient.servicePluginsDescriptor);
        Assert.assertNotNull((Object)tezClient.apiVersionInfo);
        amConf = tezClient.amConfig;
        Assert.assertNotNull((Object)amConf);
        Assert.assertEquals((long)1L, (long)amConf.getAMLocalResources().size());
        Assert.assertEquals(localResourceMap, (Object)amConf.getAMLocalResources());
        Assert.assertEquals((Object)credentials, (Object)amConf.getCredentials());
        Assert.assertTrue((boolean)amConf.getTezConfiguration().getBoolean("tez.am.mode.session", false));
    }

    @Test(timeout=5000L)
    public void testInvalidJavaOptsChecker1() throws YarnException, IOException, ServiceException, TezException {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.java.opts.checker.class", "InvalidClassName");
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.start();
    }

    @Test(timeout=5000L)
    public void testInvalidJavaOptsChecker2() throws YarnException, IOException, ServiceException, TezException {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.java.opts.checker.class", InvalidChecker.class.getName());
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.start();
    }

    @Test(timeout=5000L)
    public void testStopRetriesUntilTerminalState() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.client.asynchronous-stop", false);
        conf.setLong("tez.client.timeout-ms", 1500L);
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW).thenReturn((Object)YarnApplicationState.KILLED);
        try {
            client.stop();
        }
        catch (Exception e) {
            Assert.fail((String)"Expected ApplicationNotFoundException");
        }
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.atLeast((int)2))).getApplicationReport(client.mockAppId);
    }

    @Test(timeout=20000L)
    public void testStopRetriesUntilTimeout() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.client.asynchronous-stop", false);
        conf.setLong("tez.client.timeout-ms", 1500L);
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        long start = System.currentTimeMillis();
        try {
            client.stop();
        }
        catch (Exception e) {
            Assert.fail((String)("Stop should complete without exception: " + e));
        }
        long end = System.currentTimeMillis();
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.atLeast((int)2))).getApplicationReport(client.mockAppId);
        Assert.assertTrue((String)"Stop ended before timeout", (end - start > 1500L ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testSubmitHostPopulated() throws YarnException, IOException, ServiceException, TezException {
        TezConfiguration conf = new TezConfiguration();
        this.configureAndCreateTezClient(conf);
        InetAddress ip = InetAddress.getLocalHost();
        if (ip != null) {
            Assert.assertEquals((Object)ip.getCanonicalHostName(), (Object)conf.get("tez.submit.host"));
            Assert.assertEquals((Object)ip.getHostAddress(), (Object)conf.get("tez.submit.host.address"));
        } else {
            Assert.fail((String)"Failed to retrieve local host information");
        }
    }

    @Test(timeout=5000L)
    public void testClientResubmit() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient(null, true, null);
        client.start();
        Map<String, LocalResource> lrDAG = Collections.singletonMap("LR1", LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex vertex1 = Vertex.create((String)"Vertex1", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P1"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        vertex1.setTaskLaunchCmdOpts("-XX:+UseParallelGC -XX:+UseG1GC");
        Vertex vertex2 = Vertex.create((String)"Vertex2", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P2"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        vertex2.setTaskLaunchCmdOpts("-XX:+UseParallelGC -XX:+UseG1GC");
        DAG dag = DAG.create((String)"DAG-testClientResubmit").addVertex(vertex1).addVertex(vertex2).addTaskLocalFiles(lrDAG);
        for (int i = 0; i < 3; ++i) {
            try {
                client.submitDAG(dag);
                Assert.fail((String)"Expected TezUncheckedException here.");
                continue;
            }
            catch (TezUncheckedException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("Invalid/conflicting GC options found"));
            }
        }
        client.stop();
    }

    @Test(timeout=10000L)
    public void testMissingYarnAppStatus() throws Exception {
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationReport mockReport = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)mockReport.getApplicationId()).thenReturn((Object)appId1);
        Mockito.when((Object)mockReport.getYarnApplicationState()).thenReturn(null);
        YarnClient yarnClient = (YarnClient)Mockito.mock(YarnClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)yarnClient.createApplication().getNewApplicationResponse().getApplicationId()).thenReturn((Object)appId1);
        Mockito.when((Object)yarnClient.getApplicationReport(appId1)).thenReturn((Object)mockReport);
        TezYarnClient tezClient = new TezYarnClient(yarnClient);
        tezClient.init(new TezConfiguration(false));
        try {
            tezClient.getApplicationReport(appId1);
            Assert.fail((String)"getApplicationReport should have thrown");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testAMClientHeartbeat() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.am.client.heartbeat.timeout.secs", 10);
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.start();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + 5000L) {
            Thread.sleep(1000L);
        }
        client.stop();
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.atLeast((int)3))).getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any());
        conf.setInt("tez.am.client.heartbeat.timeout.secs", -1);
        TezClientForTest client2 = this.configureAndCreateTezClient(conf);
        client2.start();
        start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + 5000L) {
            Thread.sleep(1000L);
        }
        client2.stop();
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client2.sessionAmProxy, (VerificationMode)Mockito.times((int)0))).getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any());
    }

    @Test(timeout=20000L)
    public void testAMHeartbeatFailOnGetAMProxy_AppNotStarted() throws Exception {
        int amHeartBeatTimeoutSecs = 3;
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.am.client.heartbeat.timeout.secs", amHeartBeatTimeoutSecs);
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.callRealGetSessionAMProxy = true;
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.ACCEPTED);
        Thread.sleep(2 * amHeartBeatTimeoutSecs * 1000);
        Assert.assertFalse((boolean)client.getAMKeepAliveService().isTerminated());
    }

    @Test(timeout=20000L)
    public void testAMHeartbeatFailOnGetAMProxy_AppFailed() throws Exception {
        int amHeartBeatTimeoutSecs = 3;
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.am.client.heartbeat.timeout.secs", amHeartBeatTimeoutSecs);
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.callRealGetSessionAMProxy = true;
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FAILED);
        Thread.sleep(2 * amHeartBeatTimeoutSecs * 1000);
        Assert.assertTrue((boolean)client.getAMKeepAliveService().isTerminated());
    }

    @Test(timeout=20000L)
    public void testAMHeartbeatFailOnGetAMStatus() throws Exception {
        int amHeartBeatTimeoutSecs = 3;
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.am.client.heartbeat.timeout.secs", amHeartBeatTimeoutSecs);
        TezClientForTest client = this.configureAndCreateTezClient(conf);
        client.start();
        Mockito.when((Object)client.sessionAmProxy.getAMStatus((RpcController)Mockito.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Mockito.any())).thenThrow(new Throwable[]{new ServiceException("error")});
        client.callRealGetSessionAMProxy = true;
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FAILED);
        Thread.sleep(3 * amHeartBeatTimeoutSecs * 1000);
        Assert.assertTrue((boolean)client.getAMKeepAliveService().isTerminated());
    }

    @Test(timeout=5000L)
    public void testYarnZkDeprecatedConf() {
        Configuration conf = new Configuration(false);
        String val = "hostname:2181";
        conf.set("yarn.resourcemanager.zk-address", val);
        TezClientUtils.createFinalConfProtoForApp((Configuration)conf, null);
    }

    @Test
    public void testGetAmHostAndPort() throws Exception {
        TezClientForTest client = this.configureAndCreateTezClient(new TezConfiguration());
        Assert.assertEquals((Object)"testhost", (Object)client.getAmHost());
        Assert.assertEquals((long)1234L, (long)client.getAmPort());
    }

    public static class InvalidChecker {
    }

    class TezYarnClientForTest
    extends TezYarnClient {
        private TezClientForTest client;

        protected TezYarnClientForTest(YarnClient yarnClient, TezClientForTest client) {
            super(yarnClient);
            this.client = client;
        }

        protected DAGClientAMProtocolBlockingPB waitForProxy(long clientTimeout, Configuration conf, ApplicationId sessionAppId, UserGroupInformation ugi) throws TezException, IOException {
            if (!this.client.callRealGetSessionAMProxy) {
                return this.client.sessionAmProxy;
            }
            return super.getProxy(conf, sessionAppId, ugi);
        }

        protected DAGClientAMProtocolBlockingPB getProxy(Configuration conf, ApplicationId sessionAppId, UserGroupInformation ugi) throws TezException, IOException {
            if (!this.client.callRealGetSessionAMProxy) {
                return this.client.sessionAmProxy;
            }
            return super.getProxy(conf, sessionAppId, ugi);
        }

        public String getAmHost() {
            return "testhost";
        }

        public int getAmPort() {
            return 1234;
        }
    }

    class TezClientForTest
    extends TezClient {
        DAGClientAMProtocolBlockingPB sessionAmProxy;
        YarnClient mockYarnClient;
        ApplicationId mockAppId;
        boolean callRealGetSessionAMProxy;
        Long prewarmTimeoutMs;

        public TezClientForTest(String name, @Nullable TezConfiguration tezConf, @Nullable Map<String, LocalResource> localResources, Credentials credentials) {
            super(name, tezConf, localResources, credentials);
        }

        protected FrameworkClient createFrameworkClient() {
            return this.frameworkClient;
        }

        public void setPrewarmTimeoutMs(Long prewarmTimeoutMs) {
            this.prewarmTimeoutMs = prewarmTimeoutMs;
        }

        protected long getPrewarmWaitTimeMs() {
            return this.prewarmTimeoutMs == null ? super.getPrewarmWaitTimeMs() : this.prewarmTimeoutMs.longValue();
        }
    }
}

