/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.TimelineReaderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTimelineReaderFactory {
    @Test(timeout=5000L)
    public void testShouldUseTokenDelegationAuthStrategyForHadoop26() throws TezException {
        String returnedClassName = TimelineReaderFactory.getTimelineReaderStrategy((Configuration)((Configuration)Mockito.mock(Configuration.class)), (boolean)false, (int)0).getClass().getCanonicalName();
        Assert.assertEquals((String)"should use pseudo auth on hadoop2.4", (Object)"org.apache.tez.dag.api.client.TimelineReaderFactory.TimelineReaderTokenAuthenticatedStrategy", (Object)returnedClassName);
    }

    @Test(timeout=5000L)
    public void testPseudoAuthenticatorConnectionUrlShouldHaveUserName() throws Exception {
        ConnectionConfigurator connConf = (ConnectionConfigurator)Mockito.mock(ConnectionConfigurator.class);
        TimelineReaderFactory.TimelineReaderPseudoAuthenticatedStrategy.PseudoAuthenticatedURLConnectionFactory connectionFactory = new TimelineReaderFactory.TimelineReaderPseudoAuthenticatedStrategy.PseudoAuthenticatedURLConnectionFactory(connConf);
        String inputUrl = "http://host:8080/path";
        String expectedUrl = inputUrl + "?user.name=" + UserGroupInformation.getCurrentUser().getShortUserName();
        HttpURLConnection httpURLConnection = connectionFactory.getHttpURLConnection(new URL(inputUrl));
        Assert.assertEquals((Object)expectedUrl, (Object)httpURLConnection.getURL().toString());
    }
}

