/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.webapp.Controller;

public abstract class AbstractServletToControllerAdapter
extends Controller {
    private AtomicBoolean initialized = new AtomicBoolean(false);
    protected HttpServlet servlet;

    public void index() {
        if (this.initialized.compareAndSet(false, true)) {
            this.initServlet();
        }
        try {
            Method doGetMethod = this.servlet.getClass().getMethod("doGet", HttpServletRequest.class, HttpServletResponse.class);
            doGetMethod.setAccessible(true);
            doGetMethod.invoke((Object)this.servlet, this.request(), this.response());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ServletConfig getDummyServletConfig(final String servletName) {
        return new ServletConfig(){

            public String getServletName() {
                return servletName;
            }

            public ServletContext getServletContext() {
                return AbstractServletToControllerAdapter.this.request().getServletContext();
            }

            public Enumeration<String> getInitParameterNames() {
                return null;
            }

            public String getInitParameter(String name) {
                return null;
            }
        };
    }

    private void initServlet() {
        try {
            this.servlet.init(this.getDummyServletConfig(this.servlet.getClass().getSimpleName()));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }
}

