/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;

public class ScatterGatherEdgeManager
extends EdgeManagerPluginOnDemand {
    private AtomicReference<ArrayList<EdgeManagerPluginOnDemand.EventRouteMetadata>> commonRouteMeta = new AtomicReference();
    private Object commonRouteMetaLock = new Object();
    private int[][] sourceIndices;
    private int[][] targetIndices;

    public ScatterGatherEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
    }

    public int getNumDestinationTaskPhysicalInputs(int destinationTaskIndex) {
        return this.getContext().getSourceVertexNumTasks();
    }

    public int getNumSourceTaskPhysicalOutputs(int sourceTaskIndex) {
        int physicalOutputs = this.getContext().getDestinationVertexNumTasks();
        Preconditions.checkArgument((physicalOutputs >= 0 ? 1 : 0) != 0, (Object)"ScatterGather edge manager must have destination vertex task parallelism specified");
        return physicalOutputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<EdgeManagerPluginOnDemand.EventRouteMetadata> getOrCreateCommonRouteMeta() {
        ArrayList<EdgeManagerPluginOnDemand.EventRouteMetadata> metaData = this.commonRouteMeta.get();
        if (metaData == null) {
            Object object = this.commonRouteMetaLock;
            synchronized (object) {
                metaData = this.commonRouteMeta.get();
                if (metaData == null) {
                    int numSourceTasks = this.getContext().getSourceVertexNumTasks();
                    ArrayList localEventMeta = Lists.newArrayListWithCapacity((int)numSourceTasks);
                    int i = 0;
                    while (i < numSourceTasks) {
                        localEventMeta.add(EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{i++}, (int[])new int[]{0}));
                    }
                    Preconditions.checkState((boolean)this.commonRouteMeta.compareAndSet(null, localEventMeta));
                    metaData = this.commonRouteMeta.get();
                }
            }
        }
        return metaData;
    }

    private void createIndices() {
        int numTargetTasks = this.getContext().getDestinationVertexNumTasks();
        this.sourceIndices = new int[numTargetTasks][];
        for (int i = 0; i < numTargetTasks; ++i) {
            this.sourceIndices[i] = new int[]{i};
        }
        int numSourceTasks = this.getContext().getSourceVertexNumTasks();
        this.targetIndices = new int[numSourceTasks][];
        for (int i = 0; i < numSourceTasks; ++i) {
            this.targetIndices[i] = new int[]{i};
        }
    }

    public void prepareForRouting() throws Exception {
        this.createIndices();
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int sourceTaskIndex, int sourceOutputIndex, int destinationTaskIndex) throws Exception {
        if (sourceOutputIndex == destinationTaskIndex) {
            return this.getOrCreateCommonRouteMeta().get(sourceTaskIndex);
        }
        return null;
    }

    @Nullable
    public EdgeManagerPluginOnDemand.CompositeEventRouteMetadata routeCompositeDataMovementEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
        return EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)1, (int)this.targetIndices[sourceTaskIndex][0], (int)this.sourceIndices[destinationTaskIndex][0]);
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
        return this.getOrCreateCommonRouteMeta().get(sourceTaskIndex);
    }

    public void routeDataMovementEventToDestination(DataMovementEvent event, int sourceTaskIndex, int sourceOutputIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        destinationTaskAndInputIndices.put(sourceOutputIndex, Collections.singletonList(sourceTaskIndex));
    }

    public void routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        for (int i = 0; i < this.getContext().getDestinationVertexNumTasks(); ++i) {
            destinationTaskAndInputIndices.put(i, Collections.singletonList(sourceTaskIndex));
        }
    }

    public int routeInputErrorEventToSource(InputReadErrorEvent event, int destinationTaskIndex, int destinationFailedInputIndex) {
        return destinationFailedInputIndex;
    }

    public int routeInputErrorEventToSource(int destinationTaskIndex, int destinationFailedInputIndex) {
        return destinationFailedInputIndex;
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        return this.getContext().getDestinationVertexNumTasks();
    }
}

