/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGAppMasterReadinessService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(DAGAppMasterReadinessService.class);
    private AtomicBoolean ready = new AtomicBoolean(false);
    private int timeoutMs;

    public DAGAppMasterReadinessService(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.timeoutMs = this.getConfig().getInt("tez.am.ready.for.submit.timeout.ms", 30000);
        if (this.timeoutMs <= 0) {
            throw new TezException("timeout <= 0 is not supported for tez.am.ready.for.submit.timeout.ms");
        }
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.ready.set(true);
    }

    public void waitToBeReady() throws TezException {
        long start = System.currentTimeMillis();
        while (!this.ready.get()) {
            if (System.currentTimeMillis() - start > (long)this.timeoutMs) {
                throw new TezException("App Master is not ready within the configured time period (" + this.timeoutMs + "ms). Please check logs for AM service states.");
            }
            try {
                LOG.info("App is not ready yet, waiting 100ms");
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new TezException((Throwable)e);
            }
        }
    }
}

