/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.rm.node.AMNode;
import org.apache.tez.dag.app.rm.node.AMNodeEvent;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.PerSourceNodeTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMNodeTracker
extends AbstractService
implements EventHandler<AMNodeEvent> {
    static final Logger LOG = LoggerFactory.getLogger(AMNodeTracker.class);
    private final ConcurrentMap<Integer, PerSourceNodeTracker> perSourceNodeTrackers = new ConcurrentHashMap<Integer, PerSourceNodeTracker>();
    private final EventHandler eventHandler;
    private final AppContext appContext;
    private int maxTaskFailuresPerNode;
    private boolean nodeBlacklistingEnabled;
    private int blacklistDisablePercent;
    private boolean nodeUpdatesRescheduleEnabled;

    public AMNodeTracker(EventHandler eventHandler, AppContext appContext) {
        super("AMNodeTracker");
        this.eventHandler = eventHandler;
        this.appContext = appContext;
    }

    public synchronized void serviceInit(Configuration conf) {
        this.maxTaskFailuresPerNode = conf.getInt("tez.am.maxtaskfailures.per.node", 10);
        this.nodeBlacklistingEnabled = conf.getBoolean("tez.am.node-blacklisting.enabled", true);
        this.blacklistDisablePercent = conf.getInt("tez.am.node-blacklisting.ignore-threshold-node-percent", 33);
        this.nodeUpdatesRescheduleEnabled = conf.getBoolean("tez.am.node-unhealthy-reschedule-tasks", false);
        LOG.info("blacklistDisablePercent is " + this.blacklistDisablePercent + ", blacklistingEnabled: " + this.nodeBlacklistingEnabled + ", maxTaskFailuresPerNode: " + this.maxTaskFailuresPerNode + ", nodeUpdatesRescheduleEnabled: " + this.nodeUpdatesRescheduleEnabled);
        if (this.blacklistDisablePercent < -1 || this.blacklistDisablePercent > 100) {
            throw new TezUncheckedException("Invalid blacklistDisablePercent: " + this.blacklistDisablePercent + ". Should be an integer between 0 and 100 or -1 to disabled");
        }
    }

    public void nodeSeen(NodeId nodeId, int schedulerId) {
        PerSourceNodeTracker nodeTracker = this.getAndCreateIfNeededPerSourceTracker(schedulerId);
        nodeTracker.nodeSeen(nodeId);
    }

    boolean registerBadNodeAndShouldBlacklist(AMNode amNode, int schedulerId) {
        return ((PerSourceNodeTracker)this.perSourceNodeTrackers.get(schedulerId)).registerBadNodeAndShouldBlacklist(amNode);
    }

    public void handle(AMNodeEvent rEvent) {
        switch ((AMNodeEventType)rEvent.getType()) {
            case N_CONTAINER_ALLOCATED: 
            case N_TA_SUCCEEDED: 
            case N_TA_ENDED: 
            case N_IGNORE_BLACKLISTING_ENABLED: 
            case N_IGNORE_BLACKLISTING_DISABLED: {
                ((PerSourceNodeTracker)this.perSourceNodeTrackers.get(rEvent.getSchedulerId())).handle(rEvent);
                break;
            }
            case N_TURNED_UNHEALTHY: 
            case N_TURNED_HEALTHY: 
            case N_NODE_COUNT_UPDATED: {
                this.getAndCreateIfNeededPerSourceTracker(rEvent.getSchedulerId()).handle(rEvent);
            }
        }
    }

    public AMNode get(NodeId nodeId, int schedulerId) {
        return ((PerSourceNodeTracker)this.perSourceNodeTrackers.get(schedulerId)).get(nodeId);
    }

    public int getNumNodes(int schedulerId) {
        return ((PerSourceNodeTracker)this.perSourceNodeTrackers.get(schedulerId)).getNumNodes();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isBlacklistingIgnored(int schedulerId) {
        return ((PerSourceNodeTracker)this.perSourceNodeTrackers.get(schedulerId)).isBlacklistingIgnored();
    }

    public void dagComplete(DAG dag) {
    }

    private PerSourceNodeTracker getAndCreateIfNeededPerSourceTracker(int schedulerId) {
        PerSourceNodeTracker nodeTracker = (PerSourceNodeTracker)this.perSourceNodeTrackers.get(schedulerId);
        if (nodeTracker == null) {
            nodeTracker = new PerSourceNodeTracker(schedulerId, this.eventHandler, this.appContext, this.maxTaskFailuresPerNode, this.nodeBlacklistingEnabled, this.blacklistDisablePercent, this.nodeUpdatesRescheduleEnabled);
            PerSourceNodeTracker old = this.perSourceNodeTrackers.putIfAbsent(schedulerId, nodeTracker);
            nodeTracker = old != null ? old : nodeTracker;
        }
        return nodeTracker;
    }
}

