/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezYARNUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class MRHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(MRHelpers.class);

    private MRHelpers() {
    }

    public static void translateMRConfToTez(Configuration conf) {
        MRHelpers.translateMRConfToTez(conf, true);
    }

    public static void translateMRConfToTez(Configuration conf, boolean preferTez) {
        MRHelpers.convertVertexConfToTez(conf, preferTez);
    }

    public static void configureMRApiUsage(Configuration conf) {
        String oldMapperClass = "mapred.mapper.class";
        conf.setBooleanIfUnset("mapred.mapper.new-api", conf.get(oldMapperClass) == null);
        try {
            if (conf.getBoolean("mapred.mapper.new-api", false)) {
                String mode = "new map API";
                MRHelpers.ensureNotSet(conf, "mapred.input.format.class", mode);
                MRHelpers.ensureNotSet(conf, oldMapperClass, mode);
            } else {
                String mode = "map compatability";
                MRHelpers.ensureNotSet(conf, "mapreduce.job.inputformat.class", mode);
                MRHelpers.ensureNotSet(conf, "mapreduce.job.map.class", mode);
            }
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private static void convertVertexConfToTez(Configuration vertexConf, boolean preferTez) {
        MRHelpers.setStageKeysFromBaseConf(vertexConf, vertexConf);
        MRHelpers.processDirectConversion(vertexConf, preferTez);
        MRHelpers.setupMRComponents(vertexConf);
    }

    private static void setupMRComponents(Configuration conf) {
        if (conf.get("tez.runtime.partitioner.class") == null) {
            conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        }
        if (conf.get("tez.runtime.combiner.class") == null) {
            boolean useNewApi = conf.getBoolean("mapred.mapper.new-api", false);
            if (useNewApi) {
                if (conf.get("mapreduce.job.combine.class") != null) {
                    conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
                }
            } else if (conf.get("mapred.combiner.class") != null) {
                conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
            }
        }
    }

    private static void setStageKeysFromBaseConf(Configuration conf, Configuration baseConf) {
        JobConf jobConf = null;
        if (conf.get("tez.runtime.key.class") == null && conf.get("mapreduce.map.output.key.class") == null) {
            jobConf = new JobConf(baseConf);
            conf.set("mapreduce.map.output.key.class", jobConf.getMapOutputKeyClass().getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting mapreduce.map.output.key.class for stage: unknown based on job level configuration. Value: " + conf.get("mapreduce.map.output.key.class"));
            }
        }
        if (conf.get("tez.runtime.value.class") == null && conf.get("mapreduce.map.output.value.class") == null) {
            if (jobConf == null) {
                jobConf = new JobConf(baseConf);
            }
            conf.set("mapreduce.map.output.value.class", jobConf.getMapOutputValueClass().getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting mapreduce.map.output.value.class for stage: unknown based on job level configuration. Value: " + conf.get("mapreduce.map.output.value.class"));
            }
        }
    }

    private static void processDirectConversion(Configuration conf, boolean preferTez) {
        for (Map.Entry<String, String> dep : DeprecatedKeys.getMRToTezRuntimeParamMap().entrySet()) {
            if (conf.get(dep.getKey()) == null) continue;
            String mrValue = conf.get(dep.getKey());
            String tezValue = conf.get(dep.getValue());
            conf.unset(dep.getKey());
            if (tezValue == null) {
                conf.set(dep.getValue(), mrValue, "TRANSLATED_TO_TEZ");
            } else if (!preferTez) {
                conf.set(dep.getValue(), mrValue, "TRANSLATED_TO_TEZ_AND_MR_OVERRIDE");
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Config: mr(unset):" + dep.getKey() + ", mr initial value=" + mrValue + ", tez(original):" + dep.getValue() + "=" + tezValue + ", tez(final):" + dep.getValue() + "=" + conf.get(dep.getValue()));
        }
    }

    private static String getChildLogLevel(Configuration conf, boolean isMap) {
        if (isMap) {
            return conf.get("mapreduce.map.log.level", "INFO");
        }
        return conf.get("mapreduce.reduce.log.level", "INFO");
    }

    private static void ensureNotSet(Configuration conf, String attr, String msg) throws IOException {
        if (conf.get(attr) != null) {
            throw new IOException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    private static String getLog4jCmdLineProperties(Configuration conf, boolean isMap) {
        Vector logProps = new Vector(4);
        TezUtils.addLog4jSystemProperties((String)MRHelpers.getChildLogLevel(conf, isMap), logProps);
        StringBuilder sb = new StringBuilder();
        for (String str : logProps) {
            sb.append(str).append(" ");
        }
        return sb.toString();
    }

    public static String getJavaOptsForMRAM(Configuration conf) {
        String mrAppMasterAdminOptions = conf.get("yarn.app.mapreduce.am.admin-command-opts", "");
        String mrAppMasterUserOptions = conf.get("yarn.app.mapreduce.am.command-opts", "-Xmx1024m");
        return mrAppMasterAdminOptions.trim() + " " + mrAppMasterUserOptions.trim();
    }

    public static String getJavaOptsForMRMapper(Configuration conf) {
        String adminOpts = conf.get("mapreduce.admin.map.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        String userOpts = conf.get("mapreduce.map.java.opts", conf.get("mapred.child.java.opts", ""));
        return adminOpts.trim() + " " + userOpts.trim() + " " + MRHelpers.getLog4jCmdLineProperties(conf, true);
    }

    public static String getJavaOptsForMRReducer(Configuration conf) {
        String adminOpts = conf.get("mapreduce.admin.reduce.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        String userOpts = conf.get("mapreduce.reduce.java.opts", conf.get("mapred.child.java.opts", ""));
        return adminOpts.trim() + " " + userOpts.trim() + " " + MRHelpers.getLog4jCmdLineProperties(conf, false);
    }

    public static Resource getResourceForMRMapper(Configuration conf) {
        JobConf jobConf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        return Resource.newInstance((int)((int)jobConf.getMemoryForMapTask()), (int)jobConf.getInt("mapreduce.map.cpu.vcores", 1));
    }

    public static Resource getResourceForMRReducer(Configuration conf) {
        JobConf jobConf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        return Resource.newInstance((int)((int)jobConf.getMemoryForReduceTask()), (int)conf.getInt("mapreduce.reduce.cpu.vcores", 1));
    }

    public static void updateEnvBasedOnMRTaskEnv(Configuration conf, Map<String, String> environment, boolean isMap) {
        environment.put(ApplicationConstants.Environment.SHELL.name(), conf.get("mapreduce.admin.user.shell", "/bin/bash"));
        TezYARNUtils.addToEnvironment(environment, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)ApplicationConstants.Environment.PWD.$(), (String)File.pathSeparator);
        TezYARNUtils.appendToEnvFromInputString(environment, (String)conf.get("mapreduce.admin.user.env", "LD_LIBRARY_PATH=$HADOOP_COMMON_HOME/lib/native"), (String)File.pathSeparator);
        String mapredChildEnv = isMap ? conf.get("mapreduce.map.env", conf.get("mapred.child.env")) : conf.get("mapreduce.reduce.env", conf.get("mapred.child.env"));
        TezYARNUtils.appendToEnvFromInputString(environment, (String)mapredChildEnv, (String)File.pathSeparator);
        environment.put("HADOOP_ROOT_LOGGER", MRHelpers.getChildLogLevel(conf, isMap) + ",CLA");
    }

    public static void updateEnvBasedOnMRAMEnv(Configuration conf, Map<String, String> environment) {
        TezYARNUtils.appendToEnvFromInputString(environment, (String)conf.get("yarn.app.mapreduce.am.admin.user.env"), (String)File.pathSeparator);
        TezYARNUtils.appendToEnvFromInputString(environment, (String)conf.get("yarn.app.mapreduce.am.env"), (String)File.pathSeparator);
    }
}

