/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.mapreduce.hadoop.mapred.MRReporter;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.api.KeyValueWriterWithBasePath;

@InterfaceAudience.Public
public class MultiMROutput
extends MROutput {
    Map<String, org.apache.hadoop.mapreduce.RecordWriter<?, ?>> newRecordWriters;
    Map<String, RecordWriter<?, ?>> oldRecordWriters;

    public MultiMROutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    @Override
    public List<Event> initialize() throws IOException, InterruptedException {
        List<Event> events = super.initializeBase();
        if (this.useNewApi) {
            this.newRecordWriters = new HashMap();
        } else {
            this.oldRecordWriters = new HashMap();
        }
        return events;
    }

    public static MROutput.MROutputConfigBuilder createConfigBuilder(Configuration conf, Class<?> outputFormat, String outputPath, boolean useLazyOutputFormat) {
        return MROutput.createConfigBuilder(conf, outputFormat, outputPath, useLazyOutputFormat).setOutputClassName(MultiMROutput.class.getName());
    }

    public KeyValueWriterWithBasePath getWriter() throws IOException {
        return new KeyValueWriterWithBasePath(){

            public void write(Object key, Object value) throws IOException {
                throw new UnsupportedOperationException("Write without basePath isn't supported.");
            }

            public void write(Object key, Object value, String basePath) throws IOException {
                if (basePath == null) {
                    throw new UnsupportedOperationException("Write without basePath isn't supported.");
                }
                if (basePath.length() > 0 && basePath.charAt(0) == '/') {
                    throw new UnsupportedOperationException("Write with absolute basePath isn't supported.");
                }
                if (MultiMROutput.this.useNewApi) {
                    try {
                        MultiMROutput.this.getNewRecordWriter(MultiMROutput.this.newApiTaskAttemptContext, basePath).write(key, value);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOInterruptedException("Interrupted while writing next key-value", (Throwable)e);
                    }
                } else {
                    MultiMROutput.this.getOldRecordWriter(basePath).write(key, value);
                }
                MultiMROutput.this.outputRecordCounter.increment(1L);
                MultiMROutput.this.getContext().notifyProgress();
            }
        };
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed.getAndSet(true)) {
            return;
        }
        try {
            if (this.useNewApi) {
                for (org.apache.hadoop.mapreduce.RecordWriter<?, ?> writer : this.newRecordWriters.values()) {
                    writer.close(this.newApiTaskAttemptContext);
                }
            } else {
                for (RecordWriter<?, ?> writer : this.oldRecordWriters.values()) {
                    writer.close(null);
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while closing record writer", e);
        }
    }

    private synchronized org.apache.hadoop.mapreduce.RecordWriter getNewRecordWriter(TaskAttemptContext taskContext, String baseFileName) throws IOException, InterruptedException {
        org.apache.hadoop.mapreduce.RecordWriter writer = this.newRecordWriters.get(baseFileName);
        if (writer == null) {
            taskContext.getConfiguration().set("mapreduce.output.basename", baseFileName);
            try {
                writer = ((OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)taskContext.getConfiguration())).getRecordWriter(taskContext);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            this.newRecordWriters.put(baseFileName, writer);
        }
        return writer;
    }

    private synchronized RecordWriter getOldRecordWriter(String baseFileName) throws IOException {
        RecordWriter writer = this.oldRecordWriters.get(baseFileName);
        if (writer == null) {
            FileSystem fs = FileSystem.get((Configuration)this.jobConf);
            String finalName = this.getOutputName(baseFileName);
            writer = this.oldOutputFormat.getRecordWriter(fs, this.jobConf, finalName, (Progressable)new MRReporter(this.getContext().getCounters()));
            this.oldRecordWriters.put(baseFileName, writer);
        }
        return writer;
    }
}

