/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TezRootInputInitializer;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;
import org.apache.tez.runtime.api.events.RootInputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRInputAMSplitGenerator
implements TezRootInputInitializer {
    private static final Log LOG = LogFactory.getLog(MRInputAMSplitGenerator.class);

    public List<Event> initialize(TezRootInputInitializerContext rootInputContext) throws Exception {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRHelpers.parseMRInputPayload(rootInputContext.getUserPayload());
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to parse MRInput payload into prot: " + sw.elapsedMillis()));
        }
        if (LOG.isDebugEnabled()) {
            sw.reset().start();
        }
        Configuration conf = MRHelpers.createConfFromByteString(userPayloadProto.getConfigurationBytes());
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time converting ByteString to configuration: " + sw.elapsedMillis()));
        }
        if (LOG.isDebugEnabled()) {
            sw.reset().start();
        }
        InputSplitInfoMem inputSplitInfo = null;
        String realInputFormatName = userPayloadProto.getInputFormatName();
        if (realInputFormatName != null && !realInputFormatName.isEmpty()) {
            JobConf jobConf = new JobConf(conf);
            if (jobConf.getUseNewMapper()) {
                LOG.info((Object)"Grouping mapreduce api input splits");
                Job job = Job.getInstance((Configuration)conf);
                InputSplit[] splits = MRHelpers.generateNewSplits((JobContext)job, realInputFormatName, rootInputContext.getNumTasks());
                SerializationFactory serializationFactory = new SerializationFactory(job.getConfiguration());
                MRRuntimeProtos.MRSplitsProto.Builder splitsBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
                ArrayList locationHints = Lists.newArrayListWithCapacity((int)splits.length);
                for (InputSplit split : splits) {
                    splitsBuilder.addSplits(MRHelpers.createSplitProto(split, serializationFactory));
                    String rack = ((TezGroupedSplit)split).getRack();
                    if (rack == null) {
                        if (split.getLocations() != null) {
                            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(split.getLocations())), null));
                            continue;
                        }
                        locationHints.add(new VertexLocationHint.TaskLocationHint(null, null));
                        continue;
                    }
                    locationHints.add(new VertexLocationHint.TaskLocationHint(null, Collections.singleton(rack)));
                }
                inputSplitInfo = new InputSplitInfoMem(splitsBuilder.build(), locationHints, splits.length);
            } else {
                LOG.info((Object)"Grouping mapred api input splits");
                org.apache.hadoop.mapred.InputSplit[] splits = MRHelpers.generateOldSplits(jobConf, realInputFormatName, rootInputContext.getNumTasks());
                ArrayList locationHints = Lists.newArrayListWithCapacity((int)splits.length);
                MRRuntimeProtos.MRSplitsProto.Builder splitsBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
                for (org.apache.hadoop.mapred.InputSplit split : splits) {
                    splitsBuilder.addSplits(MRHelpers.createSplitProto(split));
                    String rack = ((org.apache.hadoop.mapred.split.TezGroupedSplit)split).getRack();
                    if (rack == null) {
                        if (split.getLocations() != null) {
                            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(split.getLocations())), null));
                            continue;
                        }
                        locationHints.add(new VertexLocationHint.TaskLocationHint(null, null));
                        continue;
                    }
                    locationHints.add(new VertexLocationHint.TaskLocationHint(null, Collections.singleton(rack)));
                }
                inputSplitInfo = new InputSplitInfoMem(splitsBuilder.build(), locationHints, splits.length);
            }
        } else {
            inputSplitInfo = MRHelpers.generateInputSplitsToMem(conf);
        }
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to create splits to mem: " + sw.elapsedMillis()));
        }
        ArrayList events = Lists.newArrayListWithCapacity((int)(inputSplitInfo.getNumTasks() + 1));
        RootInputConfigureVertexTasksEvent configureVertexEvent = new RootInputConfigureVertexTasksEvent(inputSplitInfo.getNumTasks(), inputSplitInfo.getTaskLocationHints());
        events.add(configureVertexEvent);
        MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
        int count = 0;
        for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
            RootInputDataInformationEvent diEvent = new RootInputDataInformationEvent(count++, mrSplit.toByteArray());
            events.add(diEvent);
        }
        return events;
    }
}

