/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SimpleMRProcessor
extends SimpleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMRProcessor.class);

    public SimpleMRProcessor(ProcessorContext context) {
        super(context);
    }

    protected void postOp() throws Exception {
        if (this.getOutputs() == null) {
            return;
        }
        LinkedList mrOuts = Lists.newLinkedList();
        for (LogicalOutput output : this.getOutputs().values()) {
            if (!(output instanceof MROutput)) continue;
            MROutput mrOutput = (MROutput)output;
            mrOutput.flush();
            if (!mrOutput.isCommitRequired()) continue;
            mrOuts.add((MROutput)output);
        }
        if (mrOuts.size() > 0) {
            while (!this.getContext().canCommit()) {
                Thread.sleep(100L);
            }
            boolean willAbort = false;
            IOException savedEx = null;
            for (MROutput output : mrOuts) {
                try {
                    output.commit();
                }
                catch (IOException ioe) {
                    LOG.warn("Error in committing output", (Throwable)ioe);
                    willAbort = true;
                    savedEx = ioe;
                    break;
                }
            }
            if (willAbort) {
                for (MROutput output : mrOuts) {
                    try {
                        output.abort();
                    }
                    catch (IOException ioe) {
                        LOG.warn("Error in aborting output", (Throwable)ioe);
                    }
                }
                throw savedEx;
            }
        }
    }
}

