/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.split.SplitLocationProvider;
import org.apache.hadoop.mapreduce.split.SplitLocationProviderMapReduce;
import org.apache.hadoop.mapreduce.split.SplitSizeEstimator;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.tez.mapreduce.grouper.GroupedSplitContainer;
import org.apache.tez.mapreduce.grouper.MapReduceSplitContainer;
import org.apache.tez.mapreduce.grouper.SplitContainer;
import org.apache.tez.mapreduce.grouper.SplitSizeEstimatorWrapperMapReduce;
import org.apache.tez.mapreduce.grouper.TezSplitGrouper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TezMapReduceSplitsGrouper
extends TezSplitGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(TezMapReduceSplitsGrouper.class);
    @Deprecated
    public static final String TEZ_GROUPING_SPLIT_COUNT = "tez.grouping.split-count";
    @Deprecated
    public static final String TEZ_GROUPING_SPLIT_BY_LENGTH = "tez.grouping.by-length";
    @Deprecated
    public static final boolean TEZ_GROUPING_SPLIT_BY_LENGTH_DEFAULT = true;
    @Deprecated
    public static final String TEZ_GROUPING_SPLIT_BY_COUNT = "tez.grouping.by-count";
    @Deprecated
    public static final boolean TEZ_GROUPING_SPLIT_BY_COUNT_DEFAULT = false;
    @Deprecated
    public static final String TEZ_GROUPING_SPLIT_WAVES = "tez.grouping.split-waves";
    @Deprecated
    public static final float TEZ_GROUPING_SPLIT_WAVES_DEFAULT = 1.7f;
    @Deprecated
    public static final String TEZ_GROUPING_SPLIT_MAX_SIZE = "tez.grouping.max-size";
    @Deprecated
    public static final long TEZ_GROUPING_SPLIT_MAX_SIZE_DEFAULT = 0x40000000L;
    @Deprecated
    public static final String TEZ_GROUPING_SPLIT_MIN_SIZE = "tez.grouping.min-size";
    @Deprecated
    public static final long TEZ_GROUPING_SPLIT_MIN_SIZE_DEFAULT = 0x3200000L;
    @Deprecated
    public static final String TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION = "tez.grouping.rack-split-reduction";
    @Deprecated
    public static final float TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION_DEFAULT = 0.75f;
    @Deprecated
    public static final String TEZ_GROUPING_REPEATABLE = "tez.grouping.repeatable";
    @Deprecated
    public static final boolean TEZ_GROUPING_REPEATABLE_DEFAULT = true;

    public List<InputSplit> getGroupedSplits(Configuration conf, List<InputSplit> originalSplits, int desiredNumSplits, String wrappedInputFormatName) throws IOException, InterruptedException {
        return this.getGroupedSplits(conf, originalSplits, desiredNumSplits, wrappedInputFormatName, null);
    }

    public List<InputSplit> getGroupedSplits(Configuration conf, List<InputSplit> originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimator estimator) throws IOException, InterruptedException {
        return this.getGroupedSplits(conf, originalSplits, desiredNumSplits, wrappedInputFormatName, estimator, null);
    }

    public List<InputSplit> getGroupedSplits(Configuration conf, List<InputSplit> originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimator estimator, SplitLocationProvider locationProvider) throws IOException, InterruptedException {
        Preconditions.checkArgument((originalSplits != null ? 1 : 0) != 0, (Object)"Splits must be specified");
        List originalSplitContainers = Lists.transform(originalSplits, (Function)new Function<InputSplit, SplitContainer>(){

            public SplitContainer apply(InputSplit input) {
                return new MapReduceSplitContainer(input);
            }
        });
        return Lists.transform(super.getGroupedSplits(conf, originalSplitContainers, desiredNumSplits, wrappedInputFormatName, estimator == null ? null : new SplitSizeEstimatorWrapperMapReduce(estimator), locationProvider == null ? null : new SplitLocationProviderMapReduce(locationProvider)), (Function)new Function<GroupedSplitContainer, InputSplit>(){

            public InputSplit apply(GroupedSplitContainer input) {
                List underlyingSplits = Lists.transform(input.getWrappedSplitContainers(), (Function)new Function<SplitContainer, InputSplit>(){

                    public InputSplit apply(SplitContainer input) {
                        return ((MapReduceSplitContainer)input).getRawSplit();
                    }
                });
                return new TezGroupedSplit(underlyingSplits, input.getWrappedInputFormatName(), input.getLocations(), input.getRack(), input.getLength());
            }
        });
    }

    @Deprecated
    public static TezMRSplitsGrouperConfigBuilder createConfigBuilder(Configuration conf) {
        return new TezMRSplitsGrouperConfigBuilder(conf);
    }

    @Deprecated
    public static final class TezMRSplitsGrouperConfigBuilder {
        private final Configuration conf;

        private TezMRSplitsGrouperConfigBuilder(@Nullable Configuration conf) {
            if (conf == null) {
                conf = new Configuration(false);
            }
            this.conf = conf;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitCount(int count) {
            this.conf.setInt(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_COUNT, count);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitByCount(boolean enabled) {
            this.conf.setBoolean(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_BY_COUNT, enabled);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitByLength(boolean enabled) {
            this.conf.setBoolean(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_BY_LENGTH, enabled);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitWaves(float multiplier) {
            this.conf.setFloat(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_WAVES, multiplier);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupingRackSplitSizeReduction(float rackSplitSizeReduction) {
            this.conf.setFloat(TezMapReduceSplitsGrouper.TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION, rackSplitSizeReduction);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupingSplitSize(long lowerBound, long upperBound) {
            this.conf.setLong(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_MIN_SIZE, lowerBound);
            this.conf.setLong(TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_MAX_SIZE, upperBound);
            return this;
        }

        public Configuration build() {
            return this.conf;
        }
    }
}

