/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWritable;

public class ProtoMessageWriter<T extends MessageLite>
implements Closeable {
    private final Path filePath;
    private final SequenceFile.Writer writer;
    private final ProtoMessageWritable<T> writable;

    ProtoMessageWriter(Configuration conf, Path filePath, Parser<T> parser) throws IOException {
        this.filePath = filePath;
        this.writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)filePath), SequenceFile.Writer.keyClass(NullWritable.class), SequenceFile.Writer.valueClass(ProtoMessageWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD)});
        this.writable = new ProtoMessageWritable<T>(parser);
    }

    public Path getPath() {
        return this.filePath;
    }

    public long getOffset() throws IOException {
        return this.writer.getLength();
    }

    public void writeProto(T message) throws IOException {
        this.writable.setMessage(message);
        this.writer.append((Writable)NullWritable.get(), this.writable);
    }

    public void hflush() throws IOException {
        this.writer.hflush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

