/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tez.dag.api.TezUncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeUtils {
    private static final Map<String, Class<?>> CLAZZ_CACHE = new ConcurrentHashMap();

    private static Class<?> getClazz(String className) {
        Class<?> clazz = CLAZZ_CACHE.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new TezUncheckedException("Unable to load class: " + className, (Throwable)e);
            }
        }
        return clazz;
    }

    private static <T> T getNewInstance(Class<T> clazz) {
        T instance;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new TezUncheckedException("Unable to instantiate class with 0 arguments: " + clazz.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TezUncheckedException("Unable to instantiate class with 0 arguments: " + clazz.getName(), (Throwable)e);
        }
        return instance;
    }

    public static <T> T createClazzInstance(String className) {
        Class<?> clazz = RuntimeUtils.getClazz(className);
        Object instance = RuntimeUtils.getNewInstance(clazz);
        return (T)instance;
    }
}

