/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.api.InputDescriptor;

public class InputSpec
implements Writable {
    private String sourceVertexName;
    private InputDescriptor inputDescriptor;
    private int physicalEdgeCount;

    public InputSpec() {
    }

    public InputSpec(String sourceVertexName, InputDescriptor inputDescriptor, int physicalEdgeCount) {
        this.sourceVertexName = sourceVertexName;
        this.inputDescriptor = inputDescriptor;
        this.physicalEdgeCount = physicalEdgeCount;
    }

    public String getSourceVertexName() {
        return this.sourceVertexName;
    }

    public InputDescriptor getInputDescriptor() {
        return this.inputDescriptor;
    }

    public int getPhysicalEdgeCount() {
        return this.physicalEdgeCount;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.sourceVertexName);
        out.writeInt(this.physicalEdgeCount);
        this.inputDescriptor.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.sourceVertexName = in.readUTF();
        this.physicalEdgeCount = in.readInt();
        this.inputDescriptor = new InputDescriptor();
        this.inputDescriptor.readFields(in);
    }

    public String toString() {
        return "{ sourceVertexName=" + this.sourceVertexName + ", physicalEdgeCount=" + this.physicalEdgeCount + ", inputClassName=" + this.inputDescriptor.getClassName() + " }";
    }
}

